/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek;

import com.freescale.s32ds.debug.ka.dsf.DSFInterface;
import com.freescale.s32ds.debug.ka.osek.OsekPlugin;
import com.freescale.s32ds.debug.ka.osek.implementation.IOsekKernelAware;
import com.freescale.s32ds.debug.ka.osek.implementation.IntegerListHolder;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiImplObject;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObject;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObjectAttribute;
import com.freescale.s32ds.debug.ka.osek.implementation.TypeObject;
import com.freescale.s32ds.debug.ka.osek.parser.OrtiParser;
import com.freescale.s32ds.debug.ka.osek.parser.OrtiRepository;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;

public class OsekAwareAdapter {
    protected IOsekKernelAware m_oseka;
    protected String m_debuggerID;
    protected String m_servantID;
    protected IRunControl.IExecutionDMContext m_context;
    protected OrtiParser parser;
    protected OrtiRepository m_ortiRepository;

    public OsekAwareAdapter(IRunControl.IExecutionDMContext context, String debugger, String servant) {
        this.m_debuggerID = debugger;
        this.m_servantID = servant;
        this.m_context = context;
        this.m_ortiRepository = new OrtiRepository();
        this.parser = new OrtiParser();
        String fname = this.getOrtiFileName();
        this.parser.parseFile(fname, 1, this.m_ortiRepository);
    }

    private String getOrtiFileName() {
        ILaunch[] launches;
        String fname = "";
        String projectName = "";
        String elfPath = "";
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] iLaunchArray = launches = launchManager.getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            try {
                ILaunchConfiguration lConfig = launch.getLaunchConfiguration();
                elfPath = lConfig.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "EMPTY");
                projectName = lConfig.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            }
            catch (CoreException e) {
                OsekPlugin.log(e);
            }
            ++n2;
        }
        if (elfPath.length() > 0) {
            IProject[] pr;
            int pos = elfPath.lastIndexOf(".");
            if (pos > 0) {
                elfPath = elfPath.substring(0, pos);
            }
            fname = String.valueOf(elfPath) + ".ort";
            IProject[] iProjectArray = pr = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n3 = pr.length;
            int n4 = 0;
            while (n4 < n3) {
                IProject p = iProjectArray[n4];
                if (p.isAccessible() && p.getName().equals(projectName)) {
                    fname = String.valueOf(p.getLocation().toString()) + "/" + fname;
                }
                ++n4;
            }
        }
        return fname;
    }

    public IRunControl.IExecutionDMContext getContext() {
        return this.m_context;
    }

    public String getDebugger() {
        return this.m_debuggerID;
    }

    public String getServantID() {
        return this.m_servantID;
    }

    public void SetOsekInterface(IOsekKernelAware osekaint) {
        this.m_oseka = osekaint;
    }

    public String GetOrtiVersionString() {
        if (this.parser != null && this.parser.parsedOK) {
            return String.format("KOIL ver. %s, Semantics \"%s\" ver. %s", this.m_ortiRepository.getKOILVersion(), this.m_ortiRepository.getSemanticsName(), this.m_ortiRepository.getSemanticsVersion());
        }
        return "";
    }

    public String GetImplementationName() {
        if (this.parser != null && this.parser.parsedOK) {
            return this.m_ortiRepository.getName();
        }
        return "";
    }

    public TypeObject[] GetObjectTree() {
        if (this.parser != null && this.parser.parsedOK) {
            return this.m_ortiRepository.getObjTree();
        }
        return null;
    }

    public OrtiImplObject GetImplObject(String typeName) {
        if (this.parser != null && this.parser.parsedOK) {
            return this.m_ortiRepository.getImplObject(typeName);
        }
        return null;
    }

    public OrtiObject[] GetOrtiObjects(String typeName) {
        if (this.parser != null && this.parser.parsedOK) {
            return this.m_ortiRepository.getOrtiObjects(typeName);
        }
        return null;
    }

    public boolean EvaluateAttributeList(int[] attrIDList, IntegerListHolder results, IntegerListHolder erroneousResultIDs) {
        if (attrIDList != null) {
            if (this.parser != null && this.parser.parsedOK) {
                int[] nArray = attrIDList;
                int n = attrIDList.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    OrtiObjectAttribute attr = this.m_ortiRepository.getAttrById(i);
                    if (attr == null) {
                        erroneousResultIDs.value.add(i);
                    } else if (Character.isDigit(attr.formula.charAt(0))) {
                        if (attr.formula.startsWith("0x")) {
                            results.value.add(Integer.parseInt(attr.formula.substring(2), 16));
                        } else {
                            results.value.add(Integer.parseInt(attr.formula, 10));
                        }
                    } else {
                        try {
                            results.value.add(DSFInterface.getDefault().iEvaluateExpression(this.m_context, attr.formula));
                        }
                        catch (ExecutionException e) {
                            OsekPlugin.log(e);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return false;
                        }
                    }
                    ++n2;
                }
            }
            return true;
        }
        return false;
    }

    public boolean SetTraceParams(int sessionID, int sampleTimeInterval, int traceSlots, int[] attrIDList) {
        return false;
    }

    public boolean GetAttributeTraceBuffer(int sessionID, int attrID, IntegerListHolder buffer, IntegerListHolder errors) {
        return false;
    }
}

