/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.p2.core.actions;

import com.nxp.s32ds.ext.rcp.p2.core.LockedFilesTracker;
import com.nxp.s32ds.ext.rcp.p2.core.Messages;
import com.nxp.s32ds.ext.rcp.p2.core.UnnativeTouchpoint;
import com.nxp.s32ds.ext.rcp.p2.core.actions.InstallAction;
import com.nxp.s32ds.ext.rcp.p2.core.utils.Util;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.osgi.util.NLS;

public class PlainCopyAction
extends ProvisioningAction {
    private static final String ACTION_PLAINCOPY = "plaincopy";

    public IStatus execute(Map<String, Object> parameters) {
        String source = (String)parameters.get("source");
        if (source == null) {
            return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"source", (Object)ACTION_PLAINCOPY));
        }
        IStatus retCode = Status.CANCEL_STATUS;
        LockedFilesTracker lft = new LockedFilesTracker();
        String directory = source;
        Path path = Paths.get(source, new String[0]);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            Path parent = path.getParent();
            if (parent == null) {
                return Util.createErrorMessage(NLS.bind((String)Messages.param_is_invalid, (Object)"source", (Object)ACTION_PLAINCOPY));
            }
            directory = parent.toString();
        }
        lft.setUnzipFolder(directory);
        WeakHashMap<String, Object> localParameters = new WeakHashMap<String, Object>();
        localParameters.putAll(parameters);
        IBackupStore store = UnnativeTouchpoint.getBackupStore((IProfile)parameters.get("profile"));
        if (store != null) {
            localParameters.put("backup", store);
        }
        retCode = Util.copy(localParameters, source, lft, false);
        if (localParameters.get("mergeBase") != null && localParameters.get("mergeExtra") != null) {
            retCode = InstallAction.mergeFiles(parameters);
        }
        return retCode;
    }

    public IStatus undo(Map<String, Object> parameters) {
        return Util.cleanupcopy(parameters, true, null);
    }
}

