/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.p2.core.actions;

import com.nxp.s32ds.ext.rcp.p2.core.Messages;
import com.nxp.s32ds.ext.rcp.p2.core.UnnativeTouchpoint;
import com.nxp.s32ds.ext.rcp.p2.core.utils.ExecuteUtil;
import com.nxp.s32ds.ext.rcp.p2.core.utils.Util;
import java.io.File;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.natives.LazyBackupStore;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.osgi.util.NLS;

public class ExecuteAction
extends ProvisioningAction {
    public IStatus execute(Map<String, Object> parameters) {
        IStatus retCode = Status.CANCEL_STATUS;
        WeakHashMap<String, Object> localParameters = new WeakHashMap<String, Object>();
        localParameters.putAll(parameters);
        LazyBackupStore store = (LazyBackupStore)UnnativeTouchpoint.getBackupStore((IProfile)parameters.get("profile"));
        if (store != null) {
            localParameters.put("backup", store);
        }
        if (localParameters.get("executeCommand") != null && localParameters.get("executeWD") != null && localParameters.get("commandInterpreter") != null) {
            retCode = this.executeCommand(parameters);
        }
        return retCode;
    }

    public IStatus undo(Map<String, Object> parameters) {
        return Status.OK_STATUS;
    }

    private IStatus executeCommand(Map<String, Object> parameters) {
        boolean isScript = false;
        Object wdObj = parameters.get("executeWD");
        if (!(wdObj instanceof String)) {
            Util.logError(Messages.ExecuteAction_working_directory_param_not_found);
            return Status.CANCEL_STATUS;
        }
        String wd = (String)wdObj;
        wd = Util.resolveWithVersion(wd, parameters);
        File executeWorkingDir = new File(wd);
        if (parameters.get("executeType") != null && "Script".equalsIgnoreCase((String)parameters.get("executeType"))) {
            isScript = true;
        }
        if (executeWorkingDir.exists()) {
            int retExecution = ExecuteUtil.executeCommand((String)parameters.get("executeCommand"), wd, (String)parameters.get("commandInterpreter"), isScript);
            if (retExecution != 1) {
                return Status.CANCEL_STATUS;
            }
        } else {
            Util.logError(NLS.bind((String)Messages.ExecuteAction_working_directory_does_not_exists, (Object)executeWorkingDir));
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }
}

