/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.p2.core;

import com.nxp.s32ds.ext.rcp.p2.core.Messages;
import com.nxp.s32ds.ext.rcp.p2.core.utils.Util;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.natives.ClosedBackupStoreException;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.LazyBackupStore;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.spi.Touchpoint;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.osgi.util.NLS;

public class UnnativeTouchpoint
extends Touchpoint {
    private static Map<IProfile, IBackupStore> bkpMap = new WeakHashMap<IProfile, IBackupStore>();

    public IStatus initializeOperand(IProfile profile, Map<String, Object> params) {
        IProvisioningAgent pAgent = (IProvisioningAgent)params.get("agent");
        IArtifactKey key = (IArtifactKey)params.get("artifact");
        if (key != null && !params.containsKey("artifact.short.version")) {
            Version version = key.getVersion();
            String versionStr = Util.getVersionStrWoQualifier(version);
            params.put("artifact.short.version", versionStr);
        }
        if (params.containsKey("artifact.location")) {
            return Status.OK_STATUS;
        }
        if (key == null) {
            return Status.OK_STATUS;
        }
        try {
            IFileArtifactRepository cache = Util.getDownloadCacheRepo(pAgent);
            File location = cache.getArtifactFile(key);
            if (location == null || !location.exists()) {
                return Status.OK_STATUS;
            }
            String path = location.getAbsolutePath();
            params.put("artifact.location", path);
        }
        catch (ProvisionException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    public IStatus initializePhase(IProgressMonitor monitor, IProfile prfl, String phaseId, Map<String, Object> params) {
        IBackupStore store = UnnativeTouchpoint.getBackupStore(prfl);
        params.put("backup", store);
        return null;
    }

    public String qualifyAction(String id) {
        String res = "com.nxp.s32ds.ext.rcp.p2.core".concat(".").concat(id);
        return res;
    }

    public IStatus commit(IProfile prfl) {
        IBackupStore store = UnnativeTouchpoint.getBackupStore(prfl);
        if (store != null) {
            store.discard();
        }
        return Status.OK_STATUS;
    }

    public IStatus rollback(IProfile prfl) {
        IStatus theStatus = Status.OK_STATUS;
        IBackupStore store = UnnativeTouchpoint.getBackupStore(prfl);
        String name = store.getBackupName();
        try {
            store.restore();
        }
        catch (IOException e) {
            theStatus = new Status(4, "com.nxp.s32ds.ext.rcp.p2.core", NLS.bind((String)Messages.failed_backup_restore, (Object)name), (Throwable)e);
        }
        catch (ClosedBackupStoreException e) {
            theStatus = new Status(4, "com.nxp.s32ds.ext.rcp.p2.core", NLS.bind((String)Messages.failed_backup_restore, (Object)name), (Throwable)e);
        }
        UnnativeTouchpoint.resetState(prfl);
        return theStatus;
    }

    public static String escape(String src) {
        StringBuffer buf = new StringBuffer();
        int len = src.length();
        int i = 0;
        while (i < len) {
            char c = src.charAt(i);
            char[] array = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|', '%'};
            if (Arrays.binarySearch(array, c) >= 0) {
                buf.append("%" + c + ";");
            } else {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    private static synchronized void resetState(IProfile profile) {
        bkpMap.remove(profile);
    }

    public static synchronized IBackupStore getBackupStore(IProfile profile) {
        if (profile == null) {
            return null;
        }
        IBackupStore store = bkpMap.get(profile);
        if (store == null) {
            store = new LazyBackupStore(UnnativeTouchpoint.escape(profile.getProfileId()));
            bkpMap.put(profile, store);
        }
        return store;
    }
}

