/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.installer.core.utils;

import com.nxp.s32ds.ext.rcp.runtime.Log;
import com.nxp.s32ds.rcp.modular.ModularInstallerService;
import com.nxp.s32ds.rcp.modular.ModularObject;
import com.nxp.s32ds.rcp.modular.ModularOperationStatus;
import com.nxp.s32ds.rcp.modular.ModularPack;
import com.nxp.s32ds.rcp.modular.installer.core.MIPackAgregator;
import com.nxp.s32ds.rcp.modular.installer.core.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.UninstallOperation;
import org.eclipse.equinox.p2.operations.UpdateOperation;

public final class ModularInstallerUtils {
    public static final String PLUGIN_ID = "com.nxp.s32ds.rcp.modular.installer.core";

    private ModularInstallerUtils() {
    }

    public static boolean configureUnistallButton(Collection<ModularPack> installCollect, Collection<ModularObject> selectedModularObjects) {
        if (installCollect == null || selectedModularObjects == null) {
            return false;
        }
        int countInstalledObject = 0;
        for (ModularPack modularPack : installCollect) {
            if (!selectedModularObjects.contains(modularPack)) continue;
            if (!modularPack.isUninstallable()) {
                return false;
            }
            ++countInstalledObject;
        }
        return countInstalledObject != 0 && countInstalledObject == selectedModularObjects.size();
    }

    public static IStatus installJob(ModularOperationStatus resolutionStatus, final MultiStatus installationStatus, String toShow, IProgressMonitor monitor) {
        block8: {
            try {
                try {
                    if (resolutionStatus.getStatus() == null) break block8;
                    monitor.beginTask(toShow, -1);
                    ProfileChangeOperation operation = resolutionStatus.getExecutableOperation();
                    try {
                        ProvisioningJob provisioningJob = operation.getProvisioningJob(monitor);
                        if (provisioningJob != null) {
                            provisioningJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                                public void done(IJobChangeEvent event) {
                                    installationStatus.add(event.getResult());
                                }
                            });
                            installationStatus.add(provisioningJob.runModal(monitor));
                            provisioningJob.join();
                        }
                    }
                    catch (Exception e) {
                        Log.log((IStatus)new Status(4, PLUGIN_ID, e.getMessage()));
                    }
                }
                catch (Exception e) {
                    Log.log((IStatus)new Status(4, PLUGIN_ID, e.getMessage()));
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
        return Status.OK_STATUS;
    }

    public static IStatus unistallJob(List<ModularObject> unit, ModularInstallerService service, final MultiStatus status, IProgressMonitor monitor) {
        ModularOperationStatus resolutionStatusForUninstall = service.getResolutionStatusForUninstall(unit, monitor);
        if (resolutionStatusForUninstall.getStatus().isOK()) {
            ProfileChangeOperation operation = resolutionStatusForUninstall.getExecutableOperation();
            try {
                try {
                    ProvisioningJob provisioningJob = operation.getProvisioningJob(monitor);
                    resolutionStatusForUninstall.getProvisioningSession().rememberJob((Job)provisioningJob);
                    provisioningJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            status.add(event.getResult());
                        }
                    });
                    provisioningJob.schedule();
                    provisioningJob.join();
                }
                catch (Exception e) {
                    Log.log((IStatus)new Status(4, PLUGIN_ID, e.getMessage()));
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        } else {
            ModularInstallerUtils.extractNestedStatus(status, resolutionStatusForUninstall);
            return status;
        }
        return Status.OK_STATUS;
    }

    private static void extractNestedStatus(MultiStatus status, ModularOperationStatus resolutionStatusForUninstall) {
        if (resolutionStatusForUninstall.getStatus().getChildren().length == 1 && resolutionStatusForUninstall.getStatus().getChildren()[0].getChildren().length == 1) {
            status.merge(resolutionStatusForUninstall.getStatus().getChildren()[0].getChildren()[0]);
        }
        status.merge((IStatus)resolutionStatusForUninstall.getStatus());
    }

    public static String getDialogTitleByModularOperationStatus(ModularOperationStatus resolutionStatus) {
        String dialogStr = Messages.Proccess_step_proceeding;
        if (resolutionStatus.getStatus() != null) {
            ProfileChangeOperation operation = resolutionStatus.getExecutableOperation();
            if (operation instanceof InstallOperation) {
                dialogStr = Messages.Proccess_step_installing;
            } else if (operation instanceof UninstallOperation) {
                dialogStr = Messages.Proccess_step_uninstalling;
            } else if (operation instanceof UpdateOperation) {
                dialogStr = Messages.Proccess_step_updating;
            }
        }
        return dialogStr;
    }

    public static final Collection<String> getNotAvailablePacksName(List<ModularObject> units, Collection<MIPackAgregator> availableFromRepositoryModularPack) {
        ArrayList<String> notAvailable = new ArrayList<String>();
        Collection availableNames = availableFromRepositoryModularPack.stream().map(pack -> pack.getAvailablePackFromRepository().getName()).collect(Collectors.toList());
        Collection toReinstallNames = units.stream().map(pack -> pack.getName()).collect(Collectors.toList());
        for (String string : toReinstallNames) {
            if (availableNames.contains(string)) continue;
            notAvailable.add(string);
        }
        return notAvailable;
    }

    public static List<ModularObject> getUninstalledPacks(Collection<MIPackAgregator> modelObject, Collection<ModularObject> selectedModularObjects) {
        ArrayList<ModularObject> units = new ArrayList<ModularObject>();
        if (selectedModularObjects == null) {
            return units;
        }
        List collect = modelObject.stream().map(mObject -> mObject.getInstalledPack()).collect(Collectors.toList());
        for (ModularPack modularPack : collect) {
            if (!selectedModularObjects.contains(modularPack) || !modularPack.isUninstallable()) continue;
            units.add((ModularObject)modularPack);
        }
        return units;
    }

    public static boolean configureReistallButton(Collection<ModularPack> installCollect, Collection<ModularObject> selectedModularObjects) {
        if (selectedModularObjects == null || selectedModularObjects.size() > 1) {
            return false;
        }
        return ModularInstallerUtils.configureUnistallButton(installCollect, selectedModularObjects);
    }
}

