/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.installer.core.schedulers;

import com.nxp.s32ds.ext.rcp.runtime.Log;
import com.nxp.s32ds.rcp.modular.installer.core.Messages;
import com.nxp.s32ds.rcp.modular.installer.core.schedulers.DateFormate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public abstract class MIScheduler {
    private static final String UPDATE_JOB = "Update Job";
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static long ONE_TIME_CHECK = -1L;
    private UpdateCheckJob job;
    private DateFormate dateFormate;
    private Preferences preferences;

    public MIScheduler(Preferences preferences) {
        this.preferences = preferences;
        this.dateFormate = new DateFormate(preferences);
    }

    public void storeLastUpdateTime(Preferences prefs) {
        this.dateFormate.store(Calendar.getInstance().getTime());
    }

    public void refreshModularInstallerPreference() {
        long delay = ONE_TIME_CHECK;
        long poll = ONE_TIME_CHECK;
        if (!this.preferences.getBoolean("enabled", false)) {
            if (this.job != null) {
                this.job.terminateJob();
            }
            return;
        }
        String schedule = this.preferences.get("schedule", null);
        if (schedule == null) {
            return;
        }
        if (!schedule.equals("on-startup") && schedule.equals("on-fuzzy-schedule")) {
            delay = this.computeDelay(this.preferences);
            poll = MIScheduler.computePoll(this.preferences);
            if (this.job != null) {
                this.job.terminateJob();
            }
        }
        this.startJob(delay, poll);
    }

    public void startJob(long delay, long poll) {
        if (this.job == null) {
            this.job = new UpdateCheckJob(UPDATE_JOB);
            this.job.setSystem(true);
        }
        this.setJobPrams(delay, poll);
        if (delay != ONE_TIME_CHECK && delay > 0L) {
            this.job.schedule(delay);
        } else {
            this.job.schedule();
        }
    }

    private void setJobPrams(long delay, long poll) {
        this.job.setDelay(delay);
        this.job.setPoll(poll);
    }

    public long computeDelay(Preferences pref) {
        long poll;
        long lastCheckForUpdateSinceEpoch;
        Date nowDate = Calendar.getInstance().getTime();
        long now = nowDate.getTime();
        if (now - (lastCheckForUpdateSinceEpoch = this.dateFormate.readAndStoreIfAbsent(nowDate).getTime()) >= (poll = MIScheduler.computePoll(pref)) + this.getMaxDelay(pref)) {
            return new Random().nextInt(3600000);
        }
        long delay = now - lastCheckForUpdateSinceEpoch;
        return poll - delay + (long)new Random().nextInt(28800000);
    }

    private long getMaxDelay(Preferences pref) {
        String preff = pref.get("p-delay-recurrence", null);
        if (preff == null) {
            return ONE_TIME_CHECK;
        }
        if (Messages.ModularInstaller_StartupOnceADay.equals(preff)) {
            return 21600000L;
        }
        if (Messages.ModularInstaller_StartupOnceAWeek.equals(preff)) {
            return 172800000L;
        }
        return 518400000L;
    }

    private static long computePoll(Preferences pref) {
        String preff = pref.get("p-delay-recurrence", null);
        if (preff == null) {
            return ONE_TIME_CHECK;
        }
        if (Messages.ModularInstaller_StartupOnceADay.equals(preff)) {
            return 86400000L;
        }
        if (Messages.ModularInstaller_StartupOnceAWeek.equals(preff)) {
            return 604800000L;
        }
        return 2592000000L;
    }

    protected abstract void callback(IProgressMonitor var1);

    public Set<String> getStoredPaksIdSet(Preferences prefs) {
        String prefsValue = prefs.get("storedPacksIdSet", null);
        if (prefsValue == null) {
            return Collections.EMPTY_SET;
        }
        String[] split = prefsValue.split(",");
        return Arrays.asList(split).stream().collect(Collectors.toSet());
    }

    public void storeNewPacksId(Preferences prefs, Set<String> packsId) {
        String collect = packsId.stream().collect(Collectors.joining(","));
        prefs.put("storedPacksIdSet", collect);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            Log.logError((String)e.getMessage());
        }
    }

    private class UpdateCheckJob
    extends Job {
        long poll;
        long delay;
        private AtomicBoolean terminateJob;
        private AtomicBoolean finish;

        public void setPoll(long poll) {
            this.poll = poll;
        }

        public void terminateJob() {
            this.terminateJob.set(true);
        }

        public void setDelay(long delay) {
            this.delay = delay;
        }

        public UpdateCheckJob(String name) {
            super(name);
            this.terminateJob = new AtomicBoolean(false);
            this.finish = new AtomicBoolean(true);
        }

        public boolean shouldSchedule() {
            return this.finish.get() && super.shouldSchedule();
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.finish.set(false);
            this.terminateJob.set(false);
            try {
                try {
                    while (!this.terminateJob.get()) {
                        MIScheduler.this.callback(monitor);
                        if (this.delay == ONE_TIME_CHECK || this.delay <= 0L) {
                            this.terminateJob.set(true);
                            continue;
                        }
                        this.getThread();
                        Thread.sleep(this.poll);
                    }
                }
                catch (InterruptedException e) {
                    Status status = new Status(4, "com.nxp.s32ds.rcp.modular.installer.core", e.getMessage(), (Throwable)e);
                    this.finish.set(true);
                    return status;
                }
            }
            finally {
                this.finish.set(true);
            }
            return Status.OK_STATUS;
        }
    }
}

