/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.installer.core.internal;

import com.nxp.s32ds.rcp.modular.HWFamily;
import com.nxp.s32ds.rcp.modular.ModularPack;
import com.nxp.s32ds.rcp.modular.installer.core.MIPackAgregator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class MIPackComporator
implements Comparator<MIPackAgregator> {
    public static final MIPackComporator COMPORATOR = new MIPackComporator();

    private MIPackComporator() {
    }

    @Override
    public int compare(MIPackAgregator first, MIPackAgregator second) {
        ModularPack packFirst = first.getPack();
        ModularPack packSecond = second.getPack();
        if (packFirst == null && packSecond == null) {
            return 0;
        }
        if (packFirst == null) {
            return -1;
        }
        if (packSecond == null) {
            return 1;
        }
        ArrayList<HWFamily> hwFamiliesFirst = new ArrayList<HWFamily>(packFirst.getHWFamilies());
        ArrayList<HWFamily> hwFamiliesSecond = new ArrayList<HWFamily>(packSecond.getHWFamilies());
        if (hwFamiliesFirst.isEmpty() && hwFamiliesSecond.isEmpty()) {
            int compareToIgnoreCase = packFirst.getName().compareToIgnoreCase(packSecond.getName());
            return this.normalizeCompareAnswer(compareToIgnoreCase);
        }
        if (hwFamiliesFirst.isEmpty() && !hwFamiliesSecond.isEmpty()) {
            return -1;
        }
        if (!hwFamiliesFirst.isEmpty() && hwFamiliesSecond.isEmpty()) {
            return 1;
        }
        if (hwFamiliesFirst.size() > 1) {
            Collections.sort(hwFamiliesFirst, (hw1, hw2) -> this.normalizeCompareAnswer(hw1.getName().compareToIgnoreCase(hw2.getName())));
        }
        if (hwFamiliesSecond.size() > 1) {
            Collections.sort(hwFamiliesSecond, (hw1, hw2) -> this.normalizeCompareAnswer(hw1.getName().compareToIgnoreCase(hw2.getName())));
        }
        if (hwFamiliesFirst.size() >= hwFamiliesSecond.size()) {
            return this.compareHwFamilySequence(hwFamiliesFirst, hwFamiliesSecond);
        }
        return this.compareHwFamilySequence(hwFamiliesSecond, hwFamiliesFirst);
    }

    private int compareHwFamilySequence(List<HWFamily> hwFamiliesFirst, List<HWFamily> hwFamiliesSecond) {
        for (int i = 0; i < hwFamiliesSecond.size(); ++i) {
            int normalizeCompareAnswer = this.normalizeCompareAnswer(hwFamiliesFirst.get(i).getName().compareToIgnoreCase(hwFamiliesSecond.get(i).getName()));
            if (normalizeCompareAnswer == 0) {
                continue;
            }
            return normalizeCompareAnswer;
        }
        return -1;
    }

    private int normalizeCompareAnswer(int compareToIgnoreCase) {
        if (compareToIgnoreCase < 0) {
            return -1;
        }
        if (compareToIgnoreCase == 0) {
            return 0;
        }
        return 1;
    }
}

