/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.installer.core.internal;

import com.nxp.s32ds.rcp.modular.ModularPack;
import com.nxp.s32ds.rcp.modular.Repository;
import com.nxp.s32ds.rcp.modular.installer.core.MIPackAgregator;
import com.nxp.s32ds.rcp.modular.installer.core.Messages;
import com.nxp.s32ds.rcp.modular.installer.core.internal.MIPackAgregatorImpl;
import com.nxp.s32ds.rcp.modular.installer.core.internal.MIPackComporator;
import com.nxp.s32ds.rcp.modular.internal.RepositoryImplementation;
import com.nxp.s32ds.rcp.modular.internal.core.ModularInstallerActivator;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class MIPackAgregatorRegistry {
    private static List<MIPackAgregatorImpl> miPackAgrList = new ArrayList<MIPackAgregatorImpl>();
    private static List<MIPackAgregator> availableFromRepositoryrList = new ArrayList<MIPackAgregator>();
    private static MIPackAgregatorRegistry INSTACE;

    public static synchronized MIPackAgregatorRegistry getINSTANCE() {
        if (INSTACE == null) {
            INSTACE = new MIPackAgregatorRegistry();
        }
        return INSTACE;
    }

    public void addInstalledModularPack(ModularPack obj) {
        if (this.validateAsNewPackage(obj).booleanValue()) {
            MIPackAgregatorImpl pack = new MIPackAgregatorImpl(0, obj);
            miPackAgrList.add(pack);
        }
    }

    public Repository createRepository(String name, URI location) {
        return new RepositoryImplementation(location, name);
    }

    public void addAvailableModularPack(ModularPack obj) {
        if (this.validateAsNewPackage(obj).booleanValue()) {
            MIPackAgregatorImpl pack = new MIPackAgregatorImpl(1, obj);
            miPackAgrList.add(pack);
        }
    }

    public void addAvailableFromRepositoryModularPack(ModularPack obj) {
        MIPackAgregatorImpl pack = new MIPackAgregatorImpl(3, obj);
        availableFromRepositoryrList.add(pack);
    }

    public List<MIPackAgregator> getAvailableFromRepositoryModularPack() {
        ArrayList<MIPackAgregator> lst = new ArrayList<MIPackAgregator>();
        for (MIPackAgregator iter : availableFromRepositoryrList) {
            lst.add(iter);
        }
        return lst;
    }

    public void addUpdateModularPack(ModularPack obj) {
        MIPackAgregatorImpl pack = this.getAgregatorByPackId(obj.getId());
        if (pack != null) {
            pack.addUpdatePack(obj);
        } else {
            ModularInstallerActivator.getDefault().logError(Messages.bind((String)Messages.MIPackAgregatorRegistry_UpdatePackNotFound, (Object)obj.getId()));
        }
    }

    public TreeSet<MIPackAgregator> getPackAgregatorList() {
        TreeSet<MIPackAgregator> lst = new TreeSet<MIPackAgregator>(MIPackComporator.COMPORATOR);
        for (MIPackAgregatorImpl iter : miPackAgrList) {
            lst.add(iter);
        }
        return lst;
    }

    public void clearRegister() {
        miPackAgrList.clear();
        availableFromRepositoryrList.clear();
    }

    private MIPackAgregatorRegistry() {
    }

    private MIPackAgregatorImpl getAgregatorByPackId(String packId) {
        for (MIPackAgregatorImpl iter : miPackAgrList) {
            ModularPack availablePack = iter.getAvailablePack();
            if (this.checkPackById(packId, availablePack)) {
                return iter;
            }
            ModularPack updatePack = iter.getUpdatePack();
            if (this.checkPackById(packId, updatePack)) {
                return iter;
            }
            ModularPack installedPack = iter.getInstalledPack();
            if (!this.checkPackById(packId, installedPack)) continue;
            return iter;
        }
        return null;
    }

    private Boolean validateAsNewPackage(ModularPack obj) {
        ModularPack pack = this.getPackById(obj.getId());
        if (pack != null) {
            ModularInstallerActivator.getDefault().logWarning(Messages.bind((String)Messages.MIPackAgregatorRegistry_DuplicatePack, (Object)obj.getId()));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private ModularPack getPackById(String packId) {
        for (MIPackAgregator mIPackAgregator : miPackAgrList) {
            ModularPack availablePack = mIPackAgregator.getAvailablePack();
            if (this.checkPackById(packId, availablePack)) {
                return availablePack;
            }
            ModularPack updatePack = mIPackAgregator.getUpdatePack();
            if (this.checkPackById(packId, updatePack)) {
                return updatePack;
            }
            ModularPack installedPack = mIPackAgregator.getInstalledPack();
            if (!this.checkPackById(packId, installedPack)) continue;
            return installedPack;
        }
        return null;
    }

    private boolean checkPackById(String packId, ModularPack pack) {
        if (pack != null) {
            return pack.getId().equals(packId);
        }
        return false;
    }
}

