/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.isp.launch.internal.ui;

import com.nxp.s32ds.ext.ide.resources.WorkspaceResources;
import com.nxp.s32ds.ext.rcp.runtime.Log;
import com.nxp.s32ds.mdt.ide.core.MdtIdeCore;
import com.nxp.s32ds.mdt.vpt.isp.core.launch.IspLaunchParams;
import com.nxp.s32ds.mdt.vpt.isp.core.launch.IspLaunchUtil;
import com.nxp.s32ds.mdt.vpt.isp.launch.internal.ui.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class IspLaunchMainTab
extends AbstractLaunchConfigurationTab {
    protected Text graphField;
    protected Text outputField;
    protected Text dynamicSrcFolderField;
    protected Text staticSrcFolderField;
    protected boolean emitHostFlag = true;
    protected boolean validateFlag = false;
    protected boolean ignoreValidationResultsFlag = false;
    protected boolean staticSequencerFlag = false;
    protected Button emitHostButton;
    protected Button staticSequencerButton;
    protected Button workspaceGraphButton;
    protected Button fileOutputButton;
    protected Button workspaceOutputButton;
    protected Button variablesOutputButton;
    protected boolean fInitializing = false;
    protected WidgetListener fListener = new WidgetListener();

    protected void handleFileGraphButtonSelected() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(Messages.IspMainTab_select_file);
        dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
        dialog.setFilterExtensions(new String[]{"*.isp"});
        String text = dialog.open();
        if (text != null) {
            this.graphField.setText(text);
        }
    }

    protected void handleFileOutputButtonSelected() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 8192);
        dialog.setText(Messages.IspMainTab_select_file);
        dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
        String text = dialog.open();
        if (text != null) {
            this.outputField.setText(text);
        }
    }

    protected void handleEmitHostButtonSelected() {
        this.emitHostFlag = this.emitHostButton.getSelection();
    }

    protected void handleStaticSequencerButtonSelected() {
        this.staticSequencerFlag = this.staticSequencerButton.getSelection();
    }

    private void handleVariablesButtonSelected(Text textField) {
        String variable = this.getVariable();
        if (variable != null) {
            textField.insert(variable);
        }
    }

    protected void handleBrowseWorkspaceFileSelected(Text text) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(Messages.IspMainTab_select_graph);
        dialog.setMessage(Messages.IspMainTab_select_a_graph_to_process);
        dialog.setEmptyListMessage(Messages.IspMainTab_there_is_no_graph_to_process);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        List collectFiles = Collections.emptyList();
        try {
            collectFiles = WorkspaceResources.collectFiles((String[])new String[]{"isp"});
        }
        catch (CoreException e) {
            dialog.setMessage(e.getStatus().getMessage());
            Log.log((IStatus)e.getStatus());
        }
        final HashSet<IResource> resources = new HashSet<IResource>();
        for (IFile file : collectFiles) {
            resources.addAll(IspLaunchMainTab.collect(file));
        }
        dialog.setAllowMultiple(false);
        dialog.setInitialSelection(null);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection == null || selection.length == 0 || !(selection[0] instanceof IFile)) {
                    return new Status(4, "com.nxp.s32ds.mdt.vpt.isp.ui", Messages.IspMainTab_select_isp_file);
                }
                return Status.OK_STATUS;
            }
        });
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                boolean contains = resources.contains(element);
                return contains;
            }
        });
        int buttonId = dialog.open();
        if (buttonId == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            String arg = resource.getFullPath().toString();
            text.setText(arg);
        }
    }

    private static Collection<IResource> collect(IFile file) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        IFile current = file;
        while (current != null) {
            result.add((IResource)current);
            if (current instanceof IProject) {
                return result;
            }
            current = current.getParent();
        }
        return result;
    }

    protected void handleBrowseWorkspaceFolderSelected(Text text) {
        ContainerSelectionDialog containerDialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.IspMainTab_select_folder);
        containerDialog.showClosedProjects(false);
        containerDialog.open();
        Object[] resource = containerDialog.getResult();
        String str = null;
        if (resource != null && resource.length > 0) {
            str = MdtIdeCore.toWorkspaceVariabled((String)((IPath)resource[0]).toString());
        }
        if (str != null) {
            text.setText(str);
        }
    }

    private String getVariable() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        return dialog.getVariableExpression();
    }

    public String getName() {
        return Messages.IspMainTab_name;
    }

    public Image getImage() {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        try {
            URL url = new URL("platform:/plugin/com.nxp.s32ds.vgt.ide.ui/icons/full/eview16/emit_src_code16.png");
            desc = ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            Log.log((String)"com.nxp.s32ds.mdt.vpt.isp.ui", (String)Messages.IspMainTab_error_loading_image, (Throwable)e);
        }
        return desc.createImage();
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        mainComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        this.createGraphComponent(mainComposite);
        this.createOutputComponent(mainComposite);
        this.createSrcFolderComponent(mainComposite);
        this.createEmitHostComponent(mainComposite);
        this.createStaticSequencerComponent(mainComposite);
        Dialog.applyDialogFont((Control)parent);
    }

    protected void createGraphComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.IspMainTab_graph);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.graphField = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.graphField.setLayoutData((Object)gridData);
        this.graphField.addModifyListener((ModifyListener)this.fListener);
        this.workspaceGraphButton = this.createPushButton((Composite)group, Messages.IspMainTab_browse_workspace, null);
        this.workspaceGraphButton.addSelectionListener((SelectionListener)this.fListener);
    }

    protected void createOutputComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.IspMainTab_output);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.outputField = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.outputField.setLayoutData((Object)gridData);
        this.outputField.addModifyListener((ModifyListener)this.fListener);
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        gridData = new GridData(128);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.workspaceOutputButton = this.createPushButton(buttonComposite, Messages.IspMainTab_browse_workspace, null);
        this.workspaceOutputButton.addSelectionListener((SelectionListener)this.fListener);
        this.fileOutputButton = this.createPushButton(buttonComposite, Messages.IspMainTab_browse_filesystem, null);
        this.fileOutputButton.addSelectionListener((SelectionListener)this.fListener);
        this.variablesOutputButton = this.createPushButton(buttonComposite, Messages.IspMainTab_variables, null);
        this.variablesOutputButton.addSelectionListener((SelectionListener)this.fListener);
    }

    protected void createSrcFolderComponent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(Messages.IspMainTab_dynamic_sources_folder);
        this.dynamicSrcFolderField = new Text(composite, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.dynamicSrcFolderField.setLayoutData((Object)gridData);
        this.dynamicSrcFolderField.addModifyListener((ModifyListener)this.fListener);
        label = new Label(composite, 0);
        label.setText(Messages.IspMainTab_static_sources_folder);
        this.staticSrcFolderField = new Text(composite, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.staticSrcFolderField.setLayoutData((Object)gridData);
        this.staticSrcFolderField.addModifyListener((ModifyListener)this.fListener);
    }

    protected void createEmitHostComponent(Composite parent) {
        this.emitHostButton = this.createCheckButton(parent, Messages.IspMainTab_emit_host);
        this.emitHostButton.addSelectionListener((SelectionListener)this.fListener);
    }

    protected void createStaticSequencerComponent(Composite parent) {
        this.staticSequencerButton = this.createCheckButton(parent, Messages.IspMainTab_static_sequencer);
        this.staticSequencerButton.addSelectionListener((SelectionListener)this.fListener);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fInitializing = true;
        try {
            IspLaunchParams params = IspLaunchParams.getParams((ILaunchConfiguration)configuration);
            this.graphField.setText(params.getGraphPath());
            this.outputField.setText(params.getOutputPath());
            this.dynamicSrcFolderField.setText(params.getDynamicSourceFolder());
            this.staticSrcFolderField.setText(params.getStaticSourceFolder());
            this.emitHostFlag = params.isEmitHost();
            this.staticSequencerFlag = params.isStaticSequencer();
            this.emitHostButton.setSelection(this.emitHostFlag);
            this.staticSequencerButton.setSelection(this.staticSequencerFlag);
        }
        catch (CoreException e) {
            Log.log((IStatus)e.getStatus());
        }
        this.fInitializing = false;
        this.setDirty(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        IspLaunchParams params = new IspLaunchParams();
        params.setGraphPath(this.graphField.getText().trim());
        params.setOutputPath(this.outputField.getText().trim());
        params.setDynamicSourceFolder(this.dynamicSrcFolderField.getText().trim());
        params.setStaticSourceFolder(this.staticSrcFolderField.getText().trim());
        params.setEmitHost(this.emitHostFlag);
        params.setValidate(this.validateFlag);
        params.setIgnoreValidationResult(this.ignoreValidationResultsFlag);
        params.setStaticSequencer(this.staticSequencerFlag);
        params.applyParams(configuration);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IspLaunchParams params = new IspLaunchParams();
        params.applyParams(configuration);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        return this.validateGraph() && this.validateOutput();
    }

    private boolean validateGraph() {
        String graph = this.graphField.getText().trim();
        try {
            IspLaunchUtil.getModelFile((String)graph);
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getStatus().getMessage());
            return false;
        }
        return true;
    }

    private boolean validateOutput() {
        String output = this.outputField.getText().trim();
        try {
            IspLaunchUtil.getOutput((String)output);
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getStatus().getMessage());
            return false;
        }
        return true;
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        private void update() {
            if (!IspLaunchMainTab.this.fInitializing) {
                IspLaunchMainTab.this.setDirty(true);
                IspLaunchMainTab.this.updateLaunchConfigurationDialog();
            }
        }

        public void modifyText(ModifyEvent e) {
            this.update();
        }

        public void widgetSelected(SelectionEvent e) {
            IspLaunchMainTab.this.setDirty(true);
            Object source = e.getSource();
            if (source == IspLaunchMainTab.this.workspaceGraphButton) {
                IspLaunchMainTab.this.handleBrowseWorkspaceFileSelected(IspLaunchMainTab.this.graphField);
            } else if (source == IspLaunchMainTab.this.workspaceOutputButton) {
                IspLaunchMainTab.this.handleBrowseWorkspaceFolderSelected(IspLaunchMainTab.this.outputField);
            } else if (source == IspLaunchMainTab.this.fileOutputButton) {
                IspLaunchMainTab.this.handleFileOutputButtonSelected();
            } else if (source == IspLaunchMainTab.this.variablesOutputButton) {
                IspLaunchMainTab.this.handleVariablesButtonSelected(IspLaunchMainTab.this.outputField);
            } else if (source == IspLaunchMainTab.this.emitHostButton) {
                IspLaunchMainTab.this.handleEmitHostButtonSelected();
                this.update();
            } else if (source == IspLaunchMainTab.this.staticSequencerButton) {
                IspLaunchMainTab.this.handleStaticSequencerButtonSelected();
                this.update();
            }
        }
    }
}

