/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.vpt.internal.graph.ui.representers;

import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.ApuGraphSink;
import com.nxp.s32ds.gte.apugraph.ApuGraphSource;
import com.nxp.s32ds.gte.apugraph.ApuGraphs;
import com.nxp.s32ds.gte.apugraph.ApuKernel;
import com.nxp.s32ds.gte.apugraph.ApuKernelInput;
import com.nxp.s32ds.gte.apugraph.ApuKernelOutput;
import com.nxp.s32ds.gte.apugraph.design.ApuGraphRepresenter;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.vgt.ide.core.VgtDescriptor;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class CreateGraphFromKernelRepresenter
extends ApuGraphRepresenter {
    List<ApuKernelInfo> kernels;

    public CreateGraphFromKernelRepresenter(List<ApuKernelInfo> kernels) {
        this.kernels = kernels;
    }

    public EObject createSemanticModel(VgtDescriptor descriptor) {
        if (this.kernels.isEmpty()) {
            return super.createSemanticModel(descriptor);
        }
        String modelName = descriptor.getSemanticModelName();
        ApuGraph graph = ApuGraphs.createGraph((String)modelName);
        for (ApuKernelInfo kernelInfo : this.kernels) {
            ApuGraphs.addKernel((ApuGraph)graph, (ApuKernelInfo)kernelInfo);
            ApuKernel kernel = ApuGraphs.getKernel((ApuGraph)graph, (ApuKernelInfo)kernelInfo);
            this.processInputs(graph, (List<ApuKernelInput>)kernel.getKernelInputs());
            this.processOutputs(graph, (List<ApuKernelOutput>)kernel.getKernelOutputs());
        }
        return graph;
    }

    private void processInputs(ApuGraph graph, List<ApuKernelInput> inputs) {
        for (ApuKernelInput input : inputs) {
            ApuGraphSource source = ApuGraphs.createGraphSource((ApuGraph)graph);
            input.setGraphSource(source);
        }
    }

    private void processOutputs(ApuGraph graph, List<ApuKernelOutput> outputs) {
        for (ApuKernelOutput output : outputs) {
            ApuGraphSink sink = ApuGraphs.createGraphSink((ApuGraph)graph);
            sink.setKernelOutput(output);
        }
    }
}

