/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.vpt.internal.graph.ui.handlers;

import com.nxp.s32ds.ext.emf.ecore.EmfResources;
import com.nxp.s32ds.ext.emf.ecore.semantic.SemanticElementResolver;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelSource;
import com.nxp.s32ds.mdt.vpt.apex2.core.external.Apex2ExternalHelper;
import com.nxp.s32ds.mdt.vpt.apex2.kernel.registry.Apex2KernelRegistryManager;
import com.nxp.s32ds.vgt.vpt.internal.graph.ui.GraphUiActivator;
import com.nxp.s32ds.vgt.vpt.internal.graph.ui.Messages;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class SaveKernelToExternalStorageHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        final Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (shell == null) {
            GraphUiActivator.log(Messages.SaveKernelToExternalStorageHandler_shell_is_null, null);
            return null;
        }
        if (selection.isEmpty()) {
            ErrorDialog errorDialog = new ErrorDialog(shell, Messages.SaveKernelToExternalStorageHandler_extracting_error, Messages.SaveKernelToExternalStorageHandler_extracting_error_title, (IStatus)new Status(4, "com.nxp.s32ds.vgt.vpt.graph.ui", Messages.SaveKernelToExternalStorageHandler_should_open_diagram), 4);
            errorDialog.open();
            return null;
        }
        IStructuredSelection selectedElements = selection;
        Object element = selectedElements.getFirstElement();
        EObject eObject = (EObject)Adapters.adapt((Object)element, EObject.class, (boolean)true);
        SemanticElementResolver resolver = (SemanticElementResolver)Adapters.adapt((Object)eObject, SemanticElementResolver.class, (boolean)true);
        if (resolver != null) {
            eObject = resolver.resolveSemanticElement((Object)eObject);
        }
        if (eObject == null || !(eObject instanceof ApuKernelSource)) {
            ErrorDialog errorDialog = new ErrorDialog(shell, Messages.SaveKernelToExternalStorageHandler_extracting_error, Messages.SaveKernelToExternalStorageHandler_extracting_error_title, (IStatus)new Status(4, "com.nxp.s32ds.vgt.vpt.graph.ui", Messages.SaveKernelToExternalStorageHandler_should_select_kernel), 4);
            errorDialog.open();
            return null;
        }
        final ApuKernelSource kernelSource = (ApuKernelSource)eObject;
        String path = null;
        try {
            path = Apex2ExternalHelper.getExternalPath((ApuKernelSource)kernelSource);
        }
        catch (CoreException e) {
            GraphUiActivator.log(e.getMessage(), e);
            return null;
        }
        final URI uri = URI.createFileURI((String)path);
        MessageDialog dialog = new MessageDialog(shell, Messages.SaveKernelToExternalStorageHandler_move_to_external_title, null, Messages.SaveKernelToExternalStorageHandler_move_to_external_warning_message, 4, 0, new String[]{Messages.SaveKernelToExternalStorageHandler_yes, Messages.SaveKernelToExternalStorageHandler_no});
        if (dialog.open() != 0) {
            return null;
        }
        for (ApuKernelInfo info : kernelSource.getKernelInfos()) {
            List kernelInfos = Apex2KernelRegistryManager.INSTANCE.getKernelInfosByArchetype("apex_kernel_external_root");
            boolean nameExists = kernelInfos.parallelStream().anyMatch(ki -> ki.getSource().getCategory().equals(info.getSource().getCategory()) && ki.getName().equals(info.getName()));
            if (!nameExists || (dialog = new MessageDialog(shell, Messages.SaveKernelToExternalStorageHandler_move_to_external_title, null, NLS.bind((String)Messages.SaveKernelToExternalStorageHandler_duplicates_found, (Object)info.getName()), 4, 0, new String[]{Messages.SaveKernelToExternalStorageHandler_yes, Messages.SaveKernelToExternalStorageHandler_no})).open() == 0) continue;
            return null;
        }
        URI wsUri = kernelSource.eResource().getURI();
        Path wsPath = new Path(wsUri.toPlatformString(true));
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)wsPath);
        IProject project = file.getProject();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)kernelSource);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                IStatus status = EmfResources.save((URI)uri, (EObject)kernelSource);
                if (status.equals(Status.OK_STATUS)) {
                    MessageDialog.openInformation((Shell)shell, (String)Messages.SaveKernelToExternalStorageHandler_saveDialog_title, (String)Messages.SaveKernelToExternalStorageHandler_saveDialog_OK_message);
                    Apex2KernelRegistryManager.INSTANCE.rescanArchetypes(Arrays.asList("apex_kernel_workspace_root"));
                } else {
                    MessageDialog.openError((Shell)shell, (String)Messages.SaveKernelToExternalStorageHandler_saveDialog_title, (String)NLS.bind((String)Messages.SaveKernelToExternalStorageHandler_saveDialog_Error, (Object)status.getMessage()));
                }
            }
        });
        EcoreUtil.delete((EObject)kernelSource);
        try {
            ResourcesPlugin.getWorkspace().save(true, null);
        }
        catch (CoreException coreException) {}
        Display.getDefault().asyncExec(() -> {
            try {
                new ProgressMonitorDialog(shell).run(true, true, monitor -> {
                    try {
                        project.delete(4, null);
                    }
                    catch (CoreException e) {
                        MessageDialog.openError((Shell)shell, (String)Messages.SaveKernelToExternalStorageHandler_project_deletion_error_title, (String)Messages.SaveKernelToExternalStorageHandler_project_deletion_error_msg);
                        GraphUiActivator.log(e.getMessage(), e);
                    }
                });
            }
            catch (Exception exception) {}
        });
        return null;
    }
}

