/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.vpt.graph.ui;

import com.nxp.s32ds.ext.emf.ecore.EmfResources;
import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.registry.ApuGraphOrigin;
import com.nxp.s32ds.gte.apugraph.registry.ApuGraphRegistry;
import com.nxp.s32ds.vgt.vpt.internal.graph.ui.Messages;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class VGraphUI {
    public static ApuGraph selectGraph(Shell shell, Set<ApuGraph> filter) {
        final ApuGraphOrigin origin = ApuGraphRegistry.getGraphOrigin((String)"workspace");
        if (origin != null) {
            origin.dispose();
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);
            try {
                pmd.run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        origin.load(monitor);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)shell, (String)Messages.VGraphUI_error, (String)e.getTargetException().getMessage());
                return null;
            }
        }
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ApuGraph) {
                    ApuGraph graph = (ApuGraph)element;
                    String name = graph.getName();
                    Resource eResource = graph.eResource();
                    if (eResource == null) {
                        return name;
                    }
                    Path path = Paths.get(eResource.getURI().toPlatformString(false), new String[0]);
                    String message = "{0} ({1})";
                    return NLS.bind((String)message, (Object)name, (Object)path);
                }
                return super.getText(element);
            }
        };
        List graphs = ApuGraphRegistry.getGraphs();
        Set<ApuGraph> duplicates = graphs.stream().filter(g -> Collections.frequency(graphs.stream().map(ApuGraph::getName).collect(Collectors.toList()), g.getName()) > 1).collect(Collectors.toSet());
        ArrayList toRemove = new ArrayList();
        duplicates.forEach(d -> filter.forEach(f -> {
            if (EmfResources.compareByAbsolutePath((EObject)d, (EObject)f)) {
                toRemove.add(d);
            }
        }));
        if (!toRemove.isEmpty()) {
            duplicates.removeAll(toRemove);
            graphs.removeAll(duplicates);
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)labelProvider);
        dialog.setTitle(Messages.VGraphUI_select_graph);
        dialog.setMessage(Messages.VGraphUI_enter_graph_name_prefix_or_pattern);
        dialog.setMultipleSelection(false);
        dialog.setElements(graphs.toArray());
        dialog.setHelpAvailable(false);
        if (dialog.open() != 0) {
            return null;
        }
        return (ApuGraph)dialog.getFirstResult();
    }
}

