/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.internal.registry;

import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyFlashDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyRegistry;
import com.nxp.s32ds.ext.rcp.registry.BaseRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component
public class FamilyRegistryImplementation
extends BaseRegistry
implements FamilyRegistry {
    private final Map<String, FamilyDescriptor> familyDescriptors = new HashMap<String, FamilyDescriptor>();
    private final Map<String, Collection<FamilyDeviceDescriptor>> family2familyDeviceDescriptors = new HashMap<String, Collection<FamilyDeviceDescriptor>>();
    private final Map<String, Collection<FamilyDeviceDescriptor>> device2familyDeviceDescriptors = new HashMap<String, Collection<FamilyDeviceDescriptor>>();
    private final Map<String, Collection<FamilyFlashDescriptor>> family2familyFlashDescriptors = new HashMap<String, Collection<FamilyFlashDescriptor>>();
    private final Map<String, Collection<FamilyFlashDescriptor>> flash2familyFlashDescriptors = new HashMap<String, Collection<FamilyFlashDescriptor>>();

    @Override
    public List<FamilyDescriptor> getFamilyDescriptors() {
        return new ArrayList<FamilyDescriptor>(this.familyDescriptors.values());
    }

    @Override
    public FamilyDescriptor getFamilyDescriptor(String id) {
        return this.familyDescriptors.get(id);
    }

    @Override
    public void addFamilyDescriptor(FamilyDescriptor descriptor) {
        this.addEntityDescriptor(descriptor, this.familyDescriptors, FamilyDescriptor.class);
    }

    @Override
    public void removeFamilyDescriptor(FamilyDescriptor descriptor) {
        this.removeEntityDescriptor(descriptor, this.familyDescriptors, FamilyDescriptor.class);
    }

    @Override
    public List<FamilyDeviceDescriptor> getFamilyDeviceDescriptorsByFamilyId(String familyId) {
        return this.getReferenceDescriptorsBySourceId(familyId, this.family2familyDeviceDescriptors, FamilyDeviceDescriptor.class);
    }

    @Override
    public List<FamilyDeviceDescriptor> getFamilyDeviceDescriptorsByDeviceId(String deviceId) {
        return this.getReferenceDescriptorsByTargetId(deviceId, this.device2familyDeviceDescriptors, FamilyDeviceDescriptor.class);
    }

    @Override
    public void addFamilyDeviceDescriptor(FamilyDeviceDescriptor descriptor) {
        this.addReferenceDescriptor(descriptor, this.family2familyDeviceDescriptors, this.device2familyDeviceDescriptors, FamilyDeviceDescriptor.class);
    }

    @Override
    public void removeFamilyDeviceDescriptor(FamilyDeviceDescriptor descriptor) {
        this.removeReferenceDescriptor(descriptor, this.family2familyDeviceDescriptors, this.device2familyDeviceDescriptors, FamilyDeviceDescriptor.class);
    }

    @Override
    public List<FamilyFlashDescriptor> getFamilyFlashDescriptorsByFamilyId(String familyId) {
        return this.getReferenceDescriptorsBySourceId(familyId, this.family2familyFlashDescriptors, FamilyFlashDescriptor.class);
    }

    @Override
    public List<FamilyFlashDescriptor> getFamilyFlashDescriptorsByFlashId(String flashId) {
        return this.getReferenceDescriptorsByTargetId(flashId, this.flash2familyFlashDescriptors, FamilyFlashDescriptor.class);
    }

    @Override
    public void addFamilyFlashDescriptor(FamilyFlashDescriptor descriptor) {
        this.addReferenceDescriptor(descriptor, this.family2familyFlashDescriptors, this.flash2familyFlashDescriptors, FamilyFlashDescriptor.class);
    }

    @Override
    public void removeFamilyFlashDescriptor(FamilyFlashDescriptor descriptor) {
        this.removeReferenceDescriptor(descriptor, this.family2familyFlashDescriptors, this.flash2familyFlashDescriptors, FamilyFlashDescriptor.class);
    }
}

