/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.internal.registry;

import com.nxp.s32ds.cle.runtime.hardware.registry.BoardDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.BoardDeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.BoardRegistry;
import com.nxp.s32ds.ext.rcp.registry.BaseRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component
public class BoardRegistryImplementation
extends BaseRegistry
implements BoardRegistry {
    private final Map<String, BoardDescriptor> boardDescriptors = new HashMap<String, BoardDescriptor>();
    private final Map<String, Collection<BoardDeviceDescriptor>> board2boardDeviceDescriptors = new HashMap<String, Collection<BoardDeviceDescriptor>>();
    private final Map<String, Collection<BoardDeviceDescriptor>> device2boardDeviceDescriptors = new HashMap<String, Collection<BoardDeviceDescriptor>>();

    @Override
    public List<BoardDescriptor> getBoardDescriptors() {
        return new ArrayList<BoardDescriptor>(this.boardDescriptors.values());
    }

    @Override
    public BoardDescriptor getBoardDescriptor(String boardId) {
        return this.boardDescriptors.get(boardId);
    }

    @Override
    public void addBoardDescriptor(BoardDescriptor descriptor) {
        this.addEntityDescriptor(descriptor, this.boardDescriptors, BoardDescriptor.class);
    }

    @Override
    public void removeBoardDescriptor(BoardDescriptor descriptor) {
        this.removeEntityDescriptor(descriptor, this.boardDescriptors, BoardDescriptor.class);
    }

    @Override
    public List<BoardDeviceDescriptor> getBoardDeviceDescriptorsByBoardId(String boardId) {
        return this.getReferenceDescriptorsBySourceId(boardId, this.board2boardDeviceDescriptors, BoardDeviceDescriptor.class);
    }

    @Override
    public List<BoardDeviceDescriptor> getBoardDeviceDescriptorsByDeviceId(String deviceId) {
        return this.getReferenceDescriptorsByTargetId(deviceId, this.device2boardDeviceDescriptors, BoardDeviceDescriptor.class);
    }

    @Override
    public void addBoardDeviceDescriptor(BoardDeviceDescriptor descriptor) {
        this.addReferenceDescriptor(descriptor, this.board2boardDeviceDescriptors, this.device2boardDeviceDescriptors, BoardDeviceDescriptor.class);
    }

    @Override
    public void removeBoardDeviceDescriptor(BoardDeviceDescriptor descriptor) {
        this.removeReferenceDescriptor(descriptor, this.board2boardDeviceDescriptors, this.device2boardDeviceDescriptors, BoardDeviceDescriptor.class);
    }
}

