/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.tutorial.tutorial;

import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.tutorial.tutorial.ShellTutorial;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class HighlightHandler
extends AbstractHandler {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(HighlightHandler.class);
    private static final int AUTO_CLOSE_HIGHLIGHT_TIME = 15000;
    @NonNull
    public static final String PARAMETER_WIDGET = "com.nxp.swtools.tutorial.highlight.widgetParameter";
    @NonNull
    public static final String PARAMETER_TEXT = "com.nxp.swtools.tutorial.highlight.textParameter";
    @NonNull
    public static final String PARAMETER_DURATION = "com.nxp.swtools.tutorial.highlight.durationMillisParameter";
    @NonNull
    public static final String PARAMETER_OPEN_VIEW = "com.nxp.swtools.tutorial.highlight.openView";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell activeShell;
        String testId = event.getParameter(PARAMETER_WIDGET);
        String text = event.getParameter(PARAMETER_TEXT);
        String duration = event.getParameter(PARAMETER_DURATION);
        String viewID = event.getParameter(PARAMETER_OPEN_VIEW);
        if (viewID != null && !viewID.isEmpty()) {
            PerspectivesHelper.showView((String)viewID);
        }
        if (testId != null && (activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event)) != null) {
            Display display = activeShell.getDisplay();
            display.asyncExec(() -> {
                if (!display.isDisposed()) {
                    Shell[] shells;
                    ShellTutorial tutorial = ShellTutorial.createFor(testId, activeShell);
                    if (tutorial == null && (shells = display.getShells()) != null) {
                        tutorial = ShellTutorial.createFor(testId, shells);
                    }
                    if (tutorial != null) {
                        tutorial.highlightControl(testId);
                        if (text != null) {
                            tutorial.setText(text);
                        }
                        int durationMillis = 15000;
                        if (duration != null) {
                            try {
                                durationMillis = Integer.parseInt(duration);
                            }
                            catch (NumberFormatException ex) {
                                LOGGER.log(Level.SEVERE, "Cannot parse the highlight duration parameter as an integer" + duration, ex);
                            }
                        }
                        ShellTutorial tutorialFinal = tutorial;
                        display.timerExec(durationMillis, () -> tutorialFinal.close());
                    }
                }
            });
        }
        return null;
    }
}

