/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apuprogram.design;

import com.nxp.s32ds.ext.emf.ecore.EObjects;
import com.nxp.s32ds.ext.rcp.jface.WarningDialog;
import com.nxp.s32ds.ext.sirius.SiriusCore;
import com.nxp.s32ds.gte.apuprogram.ApuProcess;
import com.nxp.s32ds.gte.apuprogram.ApuProgram;
import com.nxp.s32ds.gte.apuprogram.design.DesignMessages;
import com.nxp.s32ds.gte.apuprogram.util.ApuProgramsReconcileUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ReconcileGraphAction
implements IExternalJavaAction {
    public boolean canExecute(Collection<? extends EObject> collection) {
        ApuProcess process = (ApuProcess)EObjects.firstOrNull(collection, ApuProcess.class);
        return process != null;
    }

    private void performReconcile(ApuProcess process, IWorkbenchWindow activeWorkbenchWindow) {
        Shell shell = activeWorkbenchWindow.getShell();
        IWorkbenchPart activePart = activeWorkbenchWindow.getActivePage().getActivePart();
        if (!(activePart instanceof DiagramEditor)) {
            return;
        }
        DiagramEditor diagramEditor = (DiagramEditor)activePart;
        if (diagramEditor.isDirty()) {
            diagramEditor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        TransactionalEditingDomain editingDomain = diagramEditor.getEditingDomain();
        if (process.getGraph().eResource() == null) {
            DDiagramEditor editor = (DDiagramEditor)EclipseUIUtil.getActiveEditor();
            IStatus status = SiriusCore.reloadDiagram((EObject)process.getProgram(), (IProgressMonitor)new NullProgressMonitor(), (DDiagramEditor)editor);
            if (!status.isOK()) {
                WarningDialog.openError((Shell)shell, (String)DesignMessages.ReconcileGraphAction_warning, (String)DesignMessages.ReconcileGraphAction_update_may_be_incomplete, (IStatus)status);
            }
            return;
        }
        this.reconcileWithReload(process, editingDomain, shell);
    }

    private void reconcileWithReload(final ApuProcess process, TransactionalEditingDomain editingDomain, final Shell shell) {
        CommandStack commandStack = editingDomain.getCommandStack();
        RecordingCommand command = new RecordingCommand(editingDomain){

            protected void doExecute() {
                ReconcileGraphAction.this.handleReconcile(process, shell);
            }
        };
        commandStack.execute((Command)command);
    }

    private IStatus handleReconcile(ApuProcess process, Shell shell) {
        MultiStatus ms = new MultiStatus("com.nxp.s32ds.gte.apugraph.design", 0, new String(), null);
        ApuProgram program = process.getProgram();
        ms.add(ApuProgramsReconcileUtil.handleReconcile((ApuProcess)process));
        ms.add(ApuProgramsReconcileUtil.cleanupApuProgram((ApuProgram)program));
        if (ms.getSeverity() == 2) {
            WarningDialog.openError((Shell)shell, (String)DesignMessages.ReconcileGraphAction_warning, (String)DesignMessages.ReconcileGraphAction_warning_graphs_have_been_removed, (IStatus)ms);
        } else if (ms.getSeverity() == 4) {
            ErrorDialog.openError((Shell)shell, (String)DesignMessages.ReconcileGraphAction_error, (String)DesignMessages.ReconcileGraphAction_error_graph_not_found, (IStatus)ms);
        }
        return ms;
    }

    public void execute(Collection<? extends EObject> collection, Map<String, Object> map) {
        ApuProcess process = (ApuProcess)EObjects.firstOrNull(collection, ApuProcess.class);
        this.doUpdate(process);
    }

    public void doUpdate(final ApuProcess process) {
        final IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = activeWorkbenchWindow.getShell();
        if (process == null) {
            Status theStatus = new Status(4, "com.nxp.s32ds.gte.apuprogram.design", DesignMessages.ReconcileGraphAction_process_is_null);
            ErrorDialog.openError((Shell)shell, (String)DesignMessages.ReconcileGraphAction_error, (String)DesignMessages.ReconcileGraphAction_process_is_null, (IStatus)theStatus);
            return;
        }
        try {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    ReconcileGraphAction.this.performReconcile(process, activeWorkbenchWindow);
                }
            };
            new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            Status theStatus = new Status(4, "com.nxp.s32ds.gte.apuprogram.design", DesignMessages.ReconcileGraphAction_error_update_error, target);
            ErrorDialog.openError((Shell)shell, (String)DesignMessages.ReconcileGraphAction_error, null, (IStatus)theStatus);
        }
        catch (InterruptedException e) {
            Status theStatus = new Status(4, "com.nxp.s32ds.gte.apuprogram.design", e.getMessage());
            WarningDialog.openError((Shell)shell, (String)DesignMessages.ReconcileGraphAction_error, (String)e.getMessage(), (IStatus)theStatus);
        }
    }
}

