/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apuprogram.design;

import com.nxp.s32ds.gte.apuprogram.ApuProgram;
import com.nxp.s32ds.gte.apuprogram.ApuProgramFactory;
import com.nxp.s32ds.gte.apuprogram.design.ApuProgramDescriptor;
import com.nxp.s32ds.gte.apuprogram.design.ApuProgramDesign;
import com.nxp.s32ds.gte.apuprogram.design.DesignMessages;
import com.nxp.s32ds.mdt.ide.launch.core.MdtIdeLaunchCore;
import com.nxp.s32ds.mdt.vpt.apex2.core.launch.Apex2LaunchConfigurationUtil;
import com.nxp.s32ds.vgt.ide.core.VgtDescriptor;
import com.nxp.s32ds.vgt.ide.core.VgtRepresenter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.ecore.EObject;

public class ApuProgramRepresenter
implements VgtRepresenter {
    private List<String> viewpointNames = new ArrayList<String>();

    public ApuProgramRepresenter() {
        this.viewpointNames.add(ApuProgramDesign.APU_PROGRAM_DESIGN_VIEWPOINT);
    }

    public String getId() {
        return ApuProgramDesign.APU_PROGRAM_DESIGN_VIEWPOINT;
    }

    public VgtDescriptor createGraphDescriptor() {
        return this.createApuProgramDescriptor();
    }

    public ApuProgramDescriptor createApuProgramDescriptor() {
        ApuProgramDescriptor descriptor = new ApuProgramDescriptor();
        descriptor.setStringValueInitial(ApuProgramDescriptor.GRAPH_FOLDER_NAME, "graphs");
        descriptor.setStringValueInitial(ApuProgramDescriptor.SOURCE_FOLDER_NAME, "A53_gen/src");
        descriptor.setStringValueInitial(ApuProgramDescriptor.KERNEL_FOLDER_NAME, "APU_kernels");
        return descriptor;
    }

    public EObject createSemanticModel(VgtDescriptor descriptor) {
        ApuProgram program = ApuProgramFactory.eINSTANCE.createApuProgram();
        program.setName(descriptor.getSemanticModelName());
        return program;
    }

    public EObject createGeneratorModel(VgtDescriptor descriptor, EObject semanticModel) {
        return null;
    }

    public ILaunchConfigurationWorkingCopy createLaunchConfiguration(VgtDescriptor descriptor, EObject semanticModel, IProgressMonitor monitor) throws CoreException {
        String targetProjectName = descriptor.getTargetProjectName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(targetProjectName);
        IFolder container = MdtIdeLaunchCore.createEmitConfigurationsFolder((IProject)project, (IProgressMonitor)monitor);
        return Apex2LaunchConfigurationUtil.createConfiguration((IContainer)container, (EObject)semanticModel);
    }

    public String getSemanticFileName(VgtDescriptor descriptor) {
        String modelName = descriptor.getSemanticModelName();
        return String.valueOf(modelName) + '.' + "apuprogram";
    }

    public String getGeneratorFileName(VgtDescriptor descriptor) {
        String modelName = descriptor.getSemanticModelName();
        return String.valueOf(modelName) + '.' + "apugen";
    }

    public String getRepresentationFileName(VgtDescriptor descriptor) {
        String modelName = descriptor.getSemanticModelName();
        return String.valueOf(modelName) + '.' + "aird";
    }

    public String getLabel() {
        return DesignMessages.ApuProgramRepresenter_label;
    }

    public String getDescription() {
        return DesignMessages.ApuProgramRepresenter_description;
    }

    public List<String> getViewpointNames() {
        return this.viewpointNames;
    }

    public String getSemanticFileExtension() {
        return "apuprogram";
    }

    public String getGeneratorFileExtension() {
        return "apugen";
    }
}

