/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apuprogram.design;

import com.nxp.s32ds.ext.rcp.runtime.util.Strings;
import com.nxp.s32ds.gte.apugraph.ApuKernelInput;
import com.nxp.s32ds.gte.apukernel.ApuDataType;
import com.nxp.s32ds.gte.apukernel.ApuMemoryPart;
import com.nxp.s32ds.gte.apukernel.provider.ApuKernelEditPlugin;
import com.nxp.s32ds.gte.apuprogram.ApuColorType;
import com.nxp.s32ds.gte.apuprogram.ApuCpuType;
import com.nxp.s32ds.gte.apuprogram.ApuDataArgument;
import com.nxp.s32ds.gte.apuprogram.ApuDataDescriptor;
import com.nxp.s32ds.gte.apuprogram.ApuDefine;
import com.nxp.s32ds.gte.apuprogram.ApuImage;
import com.nxp.s32ds.gte.apuprogram.ApuImageInlet;
import com.nxp.s32ds.gte.apuprogram.ApuNumber;
import com.nxp.s32ds.gte.apuprogram.ApuPointer;
import com.nxp.s32ds.gte.apuprogram.ApuProcess;
import com.nxp.s32ds.gte.apuprogram.ApuProcessIndirect;
import com.nxp.s32ds.gte.apuprogram.ApuProcessInput;
import com.nxp.s32ds.gte.apuprogram.ApuProcessOutput;
import com.nxp.s32ds.gte.apuprogram.ApuProcessPort;
import com.nxp.s32ds.gte.apuprogram.ApuProgram;
import com.nxp.s32ds.gte.apuprogram.ApuProgramInlet;
import com.nxp.s32ds.gte.apuprogram.ApuProgramOutlet;
import com.nxp.s32ds.gte.apuprogram.ApuUnit;
import com.nxp.s32ds.gte.apuprogram.ApuVariable;
import com.nxp.s32ds.gte.apuprogram.UmatDataType;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ApuProgramPropertiesService {
    private static final String EMPTY_STRING = "";
    private static final String UMAT_FILTER_STRING = "VSDK_CV_32UC";

    public List<ApuUnit> getUnits(ApuProcess process) {
        return ApuUnit.VALUES;
    }

    public List<UmatDataType> getUmatDataTypes(ApuProcessInput input) {
        return UmatDataType.VALUES.stream().filter(udt -> !udt.getLiteral().startsWith(UMAT_FILTER_STRING)).collect(Collectors.toList());
    }

    public List<UmatDataType> getUmatDataTypes(ApuProcessOutput output) {
        return UmatDataType.VALUES.stream().filter(udt -> !udt.getLiteral().startsWith(UMAT_FILTER_STRING)).collect(Collectors.toList());
    }

    public List<ApuColorType> getColorTypes(ApuImage image) {
        return ApuColorType.VALUES;
    }

    public List<ApuDataType> getDataTypes(ApuNumber number) {
        return ApuDataType.VALUES;
    }

    public List<ApuDataType> getDataTypes(ApuPointer pointer) {
        return ApuDataType.VALUES;
    }

    public List<ApuDataType> getDataTypes(ApuProcessIndirect indirect) {
        return ApuDataType.VALUES;
    }

    public List<UmatDataType> getUmatDataTypesFromProcessInput(ApuProcessIndirect indirect) {
        return UmatDataType.VALUES.stream().filter(udt -> !udt.getLiteral().startsWith(UMAT_FILTER_STRING)).collect(Collectors.toList());
    }

    public List<ApuCpuType> getCpuTypes(ApuVariable variable) {
        return ApuCpuType.VALUES;
    }

    public String getUnitLabel(EObject param, Object candidate) {
        if (candidate instanceof ApuUnit) {
            return ((ApuUnit)candidate).getName();
        }
        return String.valueOf(candidate);
    }

    public String getUmatLabel(EObject param, Object candidate) {
        if (candidate instanceof UmatDataType) {
            return ((UmatDataType)candidate).getName();
        }
        return String.valueOf(candidate);
    }

    public String getColorTypeLabel(EObject param, Object candidate) {
        if (candidate instanceof ApuColorType) {
            return ((ApuColorType)candidate).getName();
        }
        return String.valueOf(candidate);
    }

    public String getDataTypeLabel(EObject param, Object candidate) {
        if (candidate instanceof ApuDataType) {
            return ((ApuDataType)candidate).getName();
        }
        return String.valueOf(candidate);
    }

    public String getDataTypeLabelUmat(EObject param, Object candidate) {
        if (candidate instanceof UmatDataType) {
            return ((UmatDataType)candidate).getLiteral();
        }
        return String.valueOf(candidate);
    }

    public String getCpuTypeLabel(EObject param, Object candidate) {
        if (candidate instanceof ApuCpuType) {
            return ((ApuCpuType)candidate).getName();
        }
        return String.valueOf(candidate);
    }

    public String getGraphName(ApuProcess process) {
        return process.getGraph() == null ? EMPTY_STRING : process.getGraph().getName();
    }

    public String getProcessName(ApuProcessInput input) {
        return input.getProcess() == null ? EMPTY_STRING : input.getProcess().getName();
    }

    public String getProcessName(ApuProcessOutput output) {
        return output.getProcess() == null ? EMPTY_STRING : output.getProcess().getName();
    }

    public String getProcessInputName(ApuProcessIndirect indirect) {
        return indirect.getProcessInput() == null ? EMPTY_STRING : String.format("%s.%s", indirect.getProcess().getName(), indirect.getProcessInput().getName());
    }

    public String getProgramName(ApuProcess process) {
        return process.getProgram() == null ? EMPTY_STRING : process.getProgram().getName();
    }

    public String getProgramName(ApuProgramInlet inlet) {
        return inlet.getProgram() == null ? EMPTY_STRING : inlet.getProgram().getName();
    }

    public String getProcessOutputName(ApuProgramOutlet outlet) {
        return outlet.getProcessOutput() == null ? EMPTY_STRING : String.format("%s.%s", outlet.getProcessOutput().getProcess().getName(), outlet.getProcessOutput().getName());
    }

    public String getProgramName(ApuProgramOutlet outlet) {
        return outlet.getProgram() == null ? EMPTY_STRING : outlet.getProgram().getName();
    }

    public String getGraphSourceName(ApuProcessInput input) {
        return input.getGraphSource() == null ? EMPTY_STRING : input.getGraphSource().getName();
    }

    public String getGraphSinkName(ApuProcessOutput output) {
        return output.getGraphSink() == null ? EMPTY_STRING : output.getGraphSink().getName();
    }

    public String getProcessE0DataType(ApuProcessPort port) {
        if (port != null) {
            ApuProcessInput input;
            EList inputs;
            if (port instanceof ApuProcessInput && !(inputs = (input = (ApuProcessInput)port).getGraphSource().getKernelInputs()).isEmpty()) {
                return ((ApuKernelInput)inputs.get(0)).getPortInfo().getPortElementsInfo().getE0DataType().getName();
            }
            if (port instanceof ApuProcessOutput) {
                ApuProcessOutput output = (ApuProcessOutput)port;
                return output.getGraphSink().getKernelOutput().getPortInfo().getPortElementsInfo().getE0DataType().getName();
            }
        }
        return EMPTY_STRING;
    }

    public String getProcessMemoryDataType(ApuProcessPort port) {
        if (port != null) {
            ApuProcessInput input;
            EList inputs;
            if (port instanceof ApuProcessInput && !(inputs = (input = (ApuProcessInput)port).getGraphSource().getKernelInputs()).isEmpty()) {
                return ApuProgramPropertiesService.getMemoryPartLabel(((ApuKernelInput)inputs.get(0)).getPortInfo().getPortAttrbutesInfo().getMemoryPart());
            }
            if (port instanceof ApuProcessOutput) {
                ApuProcessOutput output = (ApuProcessOutput)port;
                return ApuProgramPropertiesService.getMemoryPartLabel(output.getGraphSink().getKernelOutput().getPortInfo().getPortAttrbutesInfo().getMemoryPart());
            }
        }
        return EMPTY_STRING;
    }

    private static String getMemoryPartLabel(ApuMemoryPart candidate) {
        if (candidate == ApuMemoryPart.ATTR_CMEM) {
            return ApuKernelEditPlugin.INSTANCE.getString("_UI_ApuMemoryPart_ATTR_CMEM_literal");
        }
        if (candidate == ApuMemoryPart.ATTR_DMEM) {
            return ApuKernelEditPlugin.INSTANCE.getString("_UI_ApuMemoryPart_ATTR_DMEM_literal");
        }
        return String.valueOf(candidate);
    }

    public UmatDataType getUmatDataType(ApuProcessInput input) {
        return input.getUmatType();
    }

    public UmatDataType getUmatDataType(ApuProcessOutput output) {
        return output.getUmatType();
    }

    public ApuProcessInput getIndirectProcessInput(ApuProcessIndirect indirect) {
        return indirect.getProcessInput();
    }

    public UmatDataType getIndirectDataTypeUmat(ApuProcessIndirect indirect) {
        return indirect.getProcessInput().getUmatType();
    }

    public String getIndirectImageWidth(ApuProcessIndirect indirect) {
        ApuDataDescriptor descriptor = indirect.getDataDescriptor();
        if (descriptor != null) {
            return String.valueOf(indirect.getDataDescriptor().getImageWidth());
        }
        return EMPTY_STRING;
    }

    public String getIndirectImageHeight(ApuProcessIndirect indirect) {
        ApuDataDescriptor descriptor = indirect.getDataDescriptor();
        if (descriptor != null) {
            return String.valueOf(indirect.getDataDescriptor().getImageHeight());
        }
        return EMPTY_STRING;
    }

    public String getProgramInletName(ApuProcessInput input) {
        return input.getProgramInlet() == null ? EMPTY_STRING : input.getProgramInlet().getName();
    }

    public String getProcessOutputName(ApuProcessInput input) {
        return input.getProcessOutput() == null ? EMPTY_STRING : input.getProcessOutput().getName();
    }

    public String getColumns(ApuDataArgument arg) {
        ApuDataDescriptor descriptor = arg.getDataDescriptor();
        if (descriptor != null) {
            return String.valueOf(arg.getDataDescriptor().getImageWidth());
        }
        return EMPTY_STRING;
    }

    public String getRows(ApuDataArgument arg) {
        ApuDataDescriptor descriptor = arg.getDataDescriptor();
        if (descriptor != null) {
            return String.valueOf(arg.getDataDescriptor().getImageHeight());
        }
        return EMPTY_STRING;
    }

    public ApuDataDescriptor getDescriptor(ApuDataArgument arg) {
        return arg.getDataDescriptor();
    }

    public EObject getFilterGroup(EObject eObject) {
        return eObject;
    }

    public boolean isImageInlet(ApuImage image) {
        return image instanceof ApuImageInlet;
    }

    public String executeButtonAction(ApuImageInlet imageInlet) {
        Shell shell;
        IFile[] file;
        String path = EMPTY_STRING;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (file = WorkspaceResourceDialog.openFileSelection((Shell)(shell = activeWorkbenchWindow.getShell()), (String)"File Selection", (String)EMPTY_STRING, (boolean)false, null, null)).length == 1) {
            path = String.valueOf(file[0].getProject().getName()) + "/" + file[0].getProjectRelativePath().toString();
            imageInlet.setImageName(Strings.beforeDot((String)file[0].getName()));
            imageInlet.setImageType(file[0].getFileExtension());
        }
        return path;
    }

    public String getNameLabel(ApuProgram graph, ApuDefine define) {
        return define.getName();
    }

    public String getValueLabel(ApuProgram graph, ApuDefine define) {
        return String.valueOf(define.getValue());
    }

    public String getVariableNameLabel(ApuProgram program, ApuVariable variable) {
        return variable.getName();
    }

    public String getVariableValueLabel(ApuProgram program, ApuVariable variable) {
        return variable.getValue();
    }

    public String getVariableQualifierLabel(ApuProgram program, ApuVariable variable) {
        return variable.getQualifier();
    }

    public String getVariableCpuTypeLabel(ApuProgram program, ApuVariable variable) {
        return variable.getCpuType().getLiteral();
    }

    public String getVariableInitHereLabel(ApuProgram program, ApuVariable variable) {
        return String.valueOf(variable.isInitHere());
    }
}

