/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apuprogram.design;

import com.nxp.s32ds.ext.emf.ecore.EObjects;
import com.nxp.s32ds.gte.apuprogram.ApuProgram;
import com.nxp.s32ds.gte.apuprogram.design.DesignMessages;
import com.nxp.s32ds.gte.apuprogram.util.ApuProgramNormalizationUtils;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ApuProgramNormalizeAction
implements IExternalJavaAction {
    public boolean canExecute(Collection<? extends EObject> collection) {
        ApuProgram program = (ApuProgram)EObjects.firstOrNull(collection, ApuProgram.class);
        return program != null;
    }

    public void execute(Collection<? extends EObject> selection, Map<String, Object> map) {
        final ApuProgram program = (ApuProgram)EObjects.firstOrNull(selection, ApuProgram.class);
        if (program == null) {
            Shell shell = Display.getDefault().getActiveShell();
            MessageDialog.openError((Shell)shell, (String)DesignMessages.NormalizeDiagram_wrongDiagramTitle, (String)DesignMessages.NormalizeDiagram_wrongDiagramMessage);
            return;
        }
        try {
            DiagramEditor diagramEditor = this.getDiagramEditor();
            if (diagramEditor != null) {
                TransactionalEditingDomain editingDomain = diagramEditor.getEditingDomain();
                CommandStack commandStack = editingDomain.getCommandStack();
                RecordingCommand rcommand = new RecordingCommand(editingDomain){

                    protected void doExecute() {
                        ApuProgramNormalizationUtils.normalize((ApuProgram)program);
                        String name = program.getName();
                        program.setName("");
                        program.setName(name);
                    }
                };
                commandStack.execute((Command)rcommand);
                diagramEditor.getDiagram().eResource().setModified(true);
            }
        }
        catch (CoreException ce) {
            Shell shell = Display.getDefault().getActiveShell();
            MessageDialog.openError((Shell)shell, (String)DesignMessages.NormalizeDiagram_normalizationFailed, (String)ce.getMessage());
        }
    }

    private DiagramEditor getDiagramEditor() throws CoreException {
        try {
            IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            if (part instanceof DiagramEditor) {
                return (DiagramEditor)part;
            }
            return null;
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, "com.nxp.s32ds.gte.apuprogram.design", DesignMessages.NormalizeDiagram_ErrorMessage));
        }
    }
}

