/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apuprogram.design;

import com.nxp.s32ds.ext.emf.common.util.DiagnosticAttachment;
import com.nxp.s32ds.ext.emf.ecore.EObjects;
import com.nxp.s32ds.ext.emf.ecore.EmfResources;
import com.nxp.s32ds.ext.ide.resources.WorkspaceResources;
import com.nxp.s32ds.ext.sirius.SiriusViewpoints;
import com.nxp.s32ds.gte.apuflow.ApuUsages;
import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.design.ApuGraphRepresenter;
import com.nxp.s32ds.gte.apuprogram.ApuDefine;
import com.nxp.s32ds.gte.apuprogram.ApuImageInlet;
import com.nxp.s32ds.gte.apuprogram.ApuImageOutlet;
import com.nxp.s32ds.gte.apuprogram.ApuNumberInlet;
import com.nxp.s32ds.gte.apuprogram.ApuNumberOutlet;
import com.nxp.s32ds.gte.apuprogram.ApuPointerInlet;
import com.nxp.s32ds.gte.apuprogram.ApuPointerOutlet;
import com.nxp.s32ds.gte.apuprogram.ApuProcess;
import com.nxp.s32ds.gte.apuprogram.ApuProcessIndirect;
import com.nxp.s32ds.gte.apuprogram.ApuProcessInput;
import com.nxp.s32ds.gte.apuprogram.ApuProcessOutput;
import com.nxp.s32ds.gte.apuprogram.ApuProcessPort;
import com.nxp.s32ds.gte.apuprogram.ApuProgram;
import com.nxp.s32ds.gte.apuprogram.ApuProgramInlet;
import com.nxp.s32ds.gte.apuprogram.ApuProgramOutlet;
import com.nxp.s32ds.gte.apuprogram.ApuProgramPort;
import com.nxp.s32ds.gte.apuprogram.ApuPrograms;
import com.nxp.s32ds.gte.apuprogram.ApuRoi;
import com.nxp.s32ds.gte.apuprogram.ApuVariable;
import com.nxp.s32ds.gte.apuprogram.design.DesignMessages;
import com.nxp.s32ds.vgt.ide.core.VgtDesignService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.tools.api.command.semantic.AddSemanticResourceCommand;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallbackWithConfimation;
import org.eclipse.sirius.ui.business.internal.commands.ChangeViewpointSelectionCommand;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class ApuProgramDesignService
extends VgtDesignService {
    private static final String PREFIX_IMAGE = "Image";
    private static final String PREFIX_NUMBER = "Number";
    private static final String PREFIX_POINTER = "Pointer";
    private static final int DEFAULT_PROCESS_HEIGHT = 10;
    private static final int DEFAULT_PROCESS_WIDTH = 15;
    private static final int MAX_PORTS_DEFAULT_SIZE_PROCESS = 4;

    public boolean isConnectAllowed(EObject context, EObject presource, EObject pretarget) {
        if (presource instanceof ApuProcessOutput && pretarget instanceof ApuProgramOutlet) {
            ApuProcessOutput output = (ApuProcessOutput)presource;
            return output.getProgramOutlets().size() == 0;
        }
        if (presource instanceof ApuProcessOutput && pretarget instanceof ApuProcessInput) {
            return !((ApuProcessOutput)presource).getProcess().equals(((ApuProcessInput)pretarget).getProcess());
        }
        return true;
    }

    public boolean canCreateIndirectOrRoiInput(EObject object) {
        if (object instanceof ApuProcessInput) {
            ApuProcessInput input = (ApuProcessInput)object;
            return input.getIndirectInput() == null && input.getRoi() == null;
        }
        return false;
    }

    public Boolean checkError(EObject object) {
        if (object instanceof ApuProcessPort || object instanceof ApuProgramPort) {
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate(object);
            DiagnosticAttachment.attach((EObject)object, (Diagnostic)diagnostic);
            if (diagnostic.getSeverity() == 4) {
                return true;
            }
            return false;
        }
        return false;
    }

    public String createImageInletName(ApuImageInlet inlet) {
        return this.createProgramInletName((ApuProgramInlet)inlet, PREFIX_IMAGE);
    }

    public String createNumberInletName(ApuNumberInlet inlet) {
        return this.createProgramInletName((ApuProgramInlet)inlet, PREFIX_NUMBER);
    }

    public String createPointerInletName(ApuPointerInlet inlet) {
        return this.createProgramInletName((ApuProgramInlet)inlet, PREFIX_POINTER);
    }

    public String createProgramInletName(ApuProgramInlet inlet, String prefix) {
        List list = inlet.getProgram().getProgramInlets().stream().map(ApuProgramPort::getName).collect(Collectors.toList());
        return ApuUsages.composeNextNameWithPrefix(list, (String)prefix, (String)DesignMessages.ApuProgramDesignService_pattern_inlet);
    }

    public String createProgramDefineName(ApuDefine created) {
        EObject eContainer = created.eContainer();
        if (eContainer instanceof ApuProgram) {
            ApuProgram program = (ApuProgram)eContainer;
            List list = program.getDefines().stream().map(ApuDefine::getName).collect(Collectors.toList());
            return ApuUsages.composeNextName(list, (String)DesignMessages.ApuProgramDesignService_pattern_define);
        }
        return "";
    }

    public String createProgramVariableName(ApuVariable created) {
        EObject eContainer = created.eContainer();
        if (eContainer instanceof ApuProgram) {
            ApuProgram program = (ApuProgram)eContainer;
            List list = program.getVariables().stream().map(ApuVariable::getName).collect(Collectors.toList());
            return ApuUsages.composeNextName(list, (String)DesignMessages.ApuProgramDesignService_pattern_variable);
        }
        return "";
    }

    public String createProgramProcessName(ApuProcess process) {
        List list = process.getProgram().getProcesses().stream().map(ApuProcess::getName).collect(Collectors.toList());
        return ApuUsages.composeNextName(list, (String)DesignMessages.ApuProgramDesignService_pattern_process);
    }

    public String createProcessName(ApuProcess process) {
        String pattern = String.valueOf(ApuUsages.getNameWithoutPostfix((String)process.getName())) + "{0}";
        List list = process.getProgram().getProcesses().stream().map(ApuProcess::getName).collect(Collectors.toList());
        return ApuUsages.composeNextName(list, (String)pattern);
    }

    public String createInletName(ApuProgramInlet apuProgramInlet) {
        String pattern = String.valueOf(ApuUsages.getNameWithoutPostfix((String)apuProgramInlet.getName())) + "{0}";
        List list = apuProgramInlet.getProgram().getProgramInlets().stream().map(ApuProgramPort::getName).collect(Collectors.toList());
        return ApuUsages.composeNextName(list, (String)pattern);
    }

    public String createOutletName(ApuProgramOutlet apuProgramOutlet) {
        String pattern = String.valueOf(ApuUsages.getNameWithoutPostfix((String)apuProgramOutlet.getName())) + "{0}";
        List list = apuProgramOutlet.getProgram().getProgramOutlets().stream().map(ApuProgramPort::getName).collect(Collectors.toList());
        return ApuUsages.composeNextName(list, (String)pattern);
    }

    public String createProcessInputName(ApuProcessInput input) {
        int index = input.getProcess().getProcessInputs().size() - 1;
        String pattern = DesignMessages.ApuProgramDesignService_pattern_input;
        String format = MessageFormat.format(pattern, index);
        return format;
    }

    public String createProcessIndirectName(ApuProcessIndirect indirect) {
        String name = String.valueOf('_');
        ApuProcessInput processInput = indirect.getProcessInput();
        if (processInput != null) {
            name = processInput.getName();
        }
        String pattern = DesignMessages.ApuProgramDesignService_pattern_indirect;
        String format = MessageFormat.format(pattern, name);
        return format;
    }

    public String createProcessOutputName(ApuProcessOutput output) {
        int index = output.getProcess().getProcessInputs().size() - 1;
        String pattern = DesignMessages.ApuProgramDesignService_pattern_output;
        String format = MessageFormat.format(pattern, index);
        return format;
    }

    public String createImageOutletName(ApuImageOutlet outlet) {
        return this.createProgramOutletName((ApuProgramOutlet)outlet, PREFIX_IMAGE);
    }

    public String createNumberOutletName(ApuNumberOutlet outlet) {
        return this.createProgramOutletName((ApuProgramOutlet)outlet, PREFIX_NUMBER);
    }

    public String createPointerOutletName(ApuPointerOutlet outlet) {
        return this.createProgramOutletName((ApuProgramOutlet)outlet, PREFIX_POINTER);
    }

    public String createProgramOutletName(ApuProgramOutlet outlet, String prefix) {
        List list = outlet.getProgram().getProgramOutlets().stream().map(ApuProgramPort::getName).collect(Collectors.toList());
        return ApuUsages.composeNextNameWithPrefix(list, (String)prefix, (String)DesignMessages.ApuProgramDesignService_pattern_outlet);
    }

    public void createProccesResource(final ApuProcess process) {
        Job operation = new Job("Adding graph"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                int index = process.getProgram().getProcesses().size();
                ApuGraph graph = process.getGraph();
                if (graph == null) {
                    return status;
                }
                IFile file = WorkspaceResources.getFile((IPath)EmfResources.getPath((Resource)process.eResource()));
                IProject project = file.getProject();
                ApuGraphRepresenter representerGraph = new ApuGraphRepresenter();
                String modelName = String.valueOf(project.getName()) + '_' + index + '.' + representerGraph.getSemanticFileExtension();
                String modelPath = String.valueOf('/') + project.getName() + '/' + "model" + '/';
                String semanticPath = String.valueOf(modelPath) + '/' + modelName;
                IStatus saveSemantic = EmfResources.savePlatformResource((String)semanticPath, (EObject)graph);
                if (!saveSemantic.isOK()) {
                    return saveSemantic;
                }
                IFile airdFile = project.getFile("model/" + project.getName() + '.' + "aird");
                if (airdFile.exists()) {
                    URI airdFileURI = URI.createPlatformResourceURI((String)airdFile.getFullPath().toOSString(), (boolean)true);
                    Session session = SessionManager.INSTANCE.getSession(airdFileURI, monitor);
                    URI semanticResourceURI = URI.createPlatformResourceURI((String)semanticPath, (boolean)true);
                    AddSemanticResourceCommand addCommandToSession = new AddSemanticResourceCommand(session, semanticResourceURI, monitor);
                    session.getTransactionalEditingDomain().getCommandStack().execute((Command)addCommandToSession);
                    ViewpointSelectionCallbackWithConfimation callback = new ViewpointSelectionCallbackWithConfimation();
                    Set availableViewpoints = SiriusViewpoints.collectViewpoints((List)representerGraph.getViewpointNames());
                    ChangeViewpointSelectionCommand commandEnable = new ChangeViewpointSelectionCommand(session, (ViewpointSelection.Callback)callback, availableViewpoints, new HashSet(), true, monitor);
                    session.getTransactionalEditingDomain().getCommandStack().execute((Command)commandEnable);
                }
                return status;
            }
        };
        operation.setUser(true);
        operation.schedule();
    }

    public String getRoiLabel(ApuRoi roi) {
        String xOffset = roi.getXOffset();
        String yOffset = roi.getYOffset();
        String width = roi.getWidth();
        String heigth = roi.getHeigth();
        return MessageFormat.format(DesignMessages.ApuProgramDesignService_pattern_roi, xOffset, yOffset, width, heigth);
    }

    public Collection<EObject> getRelatedElements(EObject firstView, List<EObject> allSelectedViews, DDiagram diag) {
        HashSet<EObject> relateds = new HashSet<EObject>();
        for (EObject it : allSelectedViews) {
            if (!(it instanceof DSemanticDecorator)) continue;
            DSemanticDecorator decorator = (DSemanticDecorator)it;
            relateds.addAll(this.getRelatedElements(decorator.getTarget()));
        }
        return relateds;
    }

    public Collection<EObject> getRelatedElements(EObject eObject) {
        Session session = SessionManager.INSTANCE.getSession(eObject);
        HashSet<EObject> relatedElements = new HashSet<EObject>();
        ArrayList crossReferences = new ArrayList();
        ArrayList<EObject> doSwitch = new ArrayList<EObject>();
        if (session != null) {
            crossReferences.addAll(session.getSemanticCrossReferencer().getInverseReferences(eObject));
        }
        doSwitch.add(eObject);
        relatedElements.remove(eObject);
        relatedElements.remove(null);
        return relatedElements;
    }

    public EObject getGraph(ApuProcess process) {
        return process.getGraph();
    }

    public boolean isGraphReconcileEnabled(EObject obj) {
        return obj instanceof ApuProcess;
    }

    public Integer increaseSizeIfNeeded(EObject eObject, DNode view) {
        ApuProcess process;
        int multiplier;
        if (!(eObject instanceof ApuProcess)) {
            return -1;
        }
        if (view.getHeight() == null) {
            view.setHeight(Integer.valueOf(10));
        }
        if (view.getWidth() == null) {
            view.setWidth(Integer.valueOf(15));
        }
        if ((multiplier = Math.round(((process = (ApuProcess)eObject).getInputs().size() + process.getOutputs().size()) / 4)) > 1) {
            view.setHeight(Integer.valueOf(10 * multiplier));
            view.setWidth(Integer.valueOf(15 * multiplier));
        }
        return -1;
    }

    public void update(EObject eObject) {
        ApuProgram program = (ApuProgram)EObjects.eContainer((EObject)eObject, ApuProgram.class);
        if (program != null) {
            ApuPrograms.update((ApuProgram)program);
        }
    }
}

