/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apuprogram.design;

import com.nxp.s32ds.ext.orbit.c.defines.CDefine;
import com.nxp.s32ds.ext.rcp.jface.KeyValueValidator;
import com.nxp.s32ds.gte.apuprogram.ApuProgram;
import com.nxp.s32ds.gte.apuprogram.ApuProgramFactory;
import com.nxp.s32ds.gte.apuprogram.design.ApuCDefineAddValidator;
import com.nxp.s32ds.gte.apuprogram.design.ApuCDefineEditValidator;
import com.nxp.s32ds.gte.apuprogram.design.DesignMessages;
import com.nxp.s32ds.gte.apuprogram.dialogs.VariableEditorDialog;
import com.nxp.s32ds.gte.apuprogram.impl.ApuDefineImpl;
import com.nxp.s32ds.gte.apuprogram.impl.ApuProgramFactoryImpl;
import com.nxp.s32ds.gte.apuprogram.impl.ApuVariableImpl;
import com.nxp.s32ds.mdt.ide.c.defines.MdtCDefineRegistryManager;
import com.nxp.s32ds.mdt.ide.c.ui.CDefineEditorDialog;
import com.nxp.s32ds.mdt.vpt.apex2.core.defines.ApexDefineRegistryManager;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ApuDialogService {
    private static <R> R showDialog(ShowDialogFunction<Shell, R> s) {
        Display defaultDisplay = Display.getDefault();
        ArrayList result = new ArrayList();
        defaultDisplay.syncExec(() -> {
            try {
                Object r = s.apply(defaultDisplay.getActiveShell());
                if (r != null) {
                    result.add(r);
                }
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)defaultDisplay.getActiveShell(), (String)DesignMessages.ApuDialogService_error, null, (IStatus)e.getStatus());
            }
        });
        if (result.size() == 0) {
            return null;
        }
        return (R)result.get(0);
    }

    public ApuVariableImpl addVariable(ApuProgram program) {
        return ApuDialogService.showDialog(shell -> {
            ApuCDefineAddValidator validator = new ApuCDefineAddValidator(program, (MdtCDefineRegistryManager<ApuProgram>)ApexDefineRegistryManager.getInstance());
            VariableEditorDialog dialog = new VariableEditorDialog((Shell)shell, "Add variable", (KeyValueValidator<String, String>)validator);
            ApuVariableImpl result = dialog.getVariable();
            if (result == null) {
                return null;
            }
            ApuVariableImpl variableImpl = (ApuVariableImpl)((ApuProgramFactoryImpl)ApuProgramFactory.eINSTANCE).createApuVariable();
            variableImpl.setName(result.getName());
            variableImpl.setValue(result.getValue());
            variableImpl.setCpuType(result.getCpuType());
            variableImpl.setQualifier(result.getQualifier());
            variableImpl.setInitHere(result.isInitHere());
            return variableImpl;
        });
    }

    public void editVariable(ApuProgram program, ApuVariableImpl current) {
        ApuDialogService.showDialog(shell -> {
            ApuCDefineEditValidator validator = new ApuCDefineEditValidator(program, (MdtCDefineRegistryManager<ApuProgram>)ApexDefineRegistryManager.getInstance(), current.getName());
            VariableEditorDialog dialog = new VariableEditorDialog((Shell)shell, "Edit variable", (KeyValueValidator<String, String>)validator);
            dialog.setName(current.getName());
            dialog.setValue(current.getValue());
            dialog.setQualifier(current.getQualifier());
            dialog.setApuCpuType(current.getCpuType());
            dialog.setInitHere(current.isInitHere());
            ApuVariableImpl result = dialog.getVariable();
            if (result == null) {
                return null;
            }
            current.setName(result.getName());
            current.setValue(result.getValue());
            current.setQualifier(result.getQualifier());
            current.setCpuType(result.getCpuType());
            current.setInitHere(result.isInitHere());
            return current;
        });
    }

    public ApuDefineImpl addDefine(ApuProgram program) {
        return ApuDialogService.showDialog(shell -> {
            ApuCDefineAddValidator validator = new ApuCDefineAddValidator(program, (MdtCDefineRegistryManager<ApuProgram>)ApexDefineRegistryManager.getInstance());
            CDefineEditorDialog dialog = new CDefineEditorDialog(shell, CDefineEditorDialog.ADD_DEFINE_TITLE, (KeyValueValidator)validator);
            CDefine result = dialog.getDefine();
            if (result == null) {
                return null;
            }
            ApuDefineImpl define = (ApuDefineImpl)((ApuProgramFactoryImpl)ApuProgramFactory.eINSTANCE).createApuDefine();
            define.setName(result.getName());
            define.setValue(result.getValue());
            return define;
        });
    }

    public void editDefine(ApuProgram program, ApuDefineImpl current) {
        ApuDialogService.showDialog(shell -> {
            ApuCDefineEditValidator validator = new ApuCDefineEditValidator(program, (MdtCDefineRegistryManager<ApuProgram>)ApexDefineRegistryManager.getInstance(), current.getName());
            CDefineEditorDialog dialog = new CDefineEditorDialog(shell, CDefineEditorDialog.EDIT_DEFINE_TITLE, (KeyValueValidator)validator);
            dialog.setName(current.getName());
            dialog.setValue(current.getValue());
            CDefine result = dialog.getDefine();
            if (result == null) {
                return null;
            }
            current.setName(result.getName());
            current.setValue(result.getValue());
            return current;
        });
    }

    @FunctionalInterface
    public static interface ShowDialogFunction<T, R> {
        public R apply(T var1) throws CoreException;
    }
}

