/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.example.internal.registry.core;

import com.nxp.s32ds.cle.runtime.example.registry.ExampleDescriptor;
import com.nxp.s32ds.cle.runtime.example.registry.ExampleRegistry;
import com.nxp.s32ds.ext.ide.examples.core.ExamplePropertyParser;
import com.nxp.s32ds.ext.ide.examples.core.IExampleComponent;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;

public class ExampleProjectLoader {
    public static final String PROJECT_FILE = ".project";

    private static List<File> findProjectFiles(File fromFile) {
        ArrayList<File> listProjectFiles = new ArrayList<File>();
        if (fromFile != null && fromFile.exists()) {
            if (fromFile.isFile() && fromFile.getName().equals(PROJECT_FILE)) {
                listProjectFiles.add(fromFile);
                return listProjectFiles;
            }
            if (fromFile.isDirectory()) {
                File[] fileArray = fromFile.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File sfile = fileArray[n2];
                    listProjectFiles.addAll(ExampleProjectLoader.findProjectFiles(sfile));
                    ++n2;
                }
            }
        }
        return listProjectFiles;
    }

    private static List<IExampleComponent> loadModelObject(List<File> listProjectFiles, File contentFolder) {
        ArrayList<IExampleComponent> listProjects = new ArrayList<IExampleComponent>();
        for (File file : listProjectFiles) {
            Path relativePath = contentFolder.toPath().relativize(file.toPath());
            ArrayList<String> grouplist = new ArrayList<String>();
            int lastIndexPath = relativePath.getNameCount() - 2;
            int i = 0;
            while (i < lastIndexPath) {
                String strSegmentPath = relativePath.getName(i).toString();
                grouplist.add(strSegmentPath);
                ++i;
            }
            String group = String.join((CharSequence)";", grouplist);
            listProjects.add(ExamplePropertyParser.parseToModelObject((File)file, (String)group));
        }
        return listProjects;
    }

    public static Map<String, List<IExampleComponent>> loadFromExtension(ExampleRegistry exampleRegistry) throws CoreException {
        HashMap<String, List<IExampleComponent>> mapProjects = new HashMap<String, List<IExampleComponent>>();
        for (ExampleDescriptor iter : exampleRegistry.getExampleDescriptors()) {
            File contentFolder = new File(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(iter.getPath(), true));
            List<File> listProjectFiles = ExampleProjectLoader.findProjectFiles(contentFolder);
            List<IExampleComponent> listProjects = ExampleProjectLoader.loadModelObject(listProjectFiles, contentFolder);
            if (mapProjects.containsKey(iter.getName())) {
                listProjects.addAll((Collection)mapProjects.get(iter.getName()));
            }
            mapProjects.put(iter.getName(), listProjects);
        }
        return mapProjects;
    }
}

