/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core.errorParsers;

import com.freescale.s32ds.cdt.core.IErrorParserManagerDelegate;
import com.freescale.s32ds.cdt.core.IErrorParserProcessor;
import com.freescale.s32ds.cdt.core.IFSLErrorParser4;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.cdt.core.errorparsers.ErrorParserNamedWrapper;

public class ErrorParserManagerDelegate
implements IErrorParserManagerDelegate {
    private ArrayList<IErrorParser> fSlowErrorParsers;
    private Pattern fQuickErrorParserPattern = null;
    private Set<IErrorParser> quickErrorParsers = new HashSet<IErrorParser>();

    public void initialize(IErrorParserProcessor manager) {
        this.fSlowErrorParsers = new ArrayList();
        StringBuilder generalPattern = new StringBuilder();
        for (IErrorParser errorParser : manager.getErrorParsers()) {
            IErrorParser innerParser;
            String expression = null;
            if (errorParser instanceof IFSLErrorParser4) {
                expression = ((IFSLErrorParser4)errorParser).getRegularExpresion();
            } else if (errorParser instanceof ErrorParserNamedWrapper && (innerParser = ((ErrorParserNamedWrapper)errorParser).getErrorParser()) instanceof IFSLErrorParser4) {
                expression = ((IFSLErrorParser4)innerParser).getRegularExpresion();
            }
            if (expression == null) {
                this.fSlowErrorParsers.add(errorParser);
                continue;
            }
            this.quickErrorParsers.add(errorParser instanceof ErrorParserNamedWrapper ? ((ErrorParserNamedWrapper)errorParser).getErrorParser() : errorParser);
            if (generalPattern.length() > 0) {
                generalPattern.append("|");
            }
            generalPattern.append("(");
            generalPattern.append(expression);
            generalPattern.append(")");
        }
        this.fQuickErrorParserPattern = Pattern.compile(generalPattern.toString());
    }

    public boolean processLine(String line, IErrorParserProcessor manager) {
        if (this.fQuickErrorParserPattern != null && !this.fQuickErrorParserPattern.matcher(line).matches()) {
            manager.processErrorParsers(line, this.fSlowErrorParsers);
            return true;
        }
        return false;
    }

    public boolean isQuickErrorParser(IErrorParser parser) {
        return this.quickErrorParsers.contains(parser);
    }
}

