/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.examples.core;

import com.nxp.s32ds.ext.ide.examples.core.ExampleComponent;
import com.nxp.s32ds.ext.ide.examples.core.ExampleProjectLoaderUtils;
import com.nxp.s32ds.ext.ide.examples.core.IExampleComponent;
import com.nxp.s32ds.ext.rcp.runtime.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class ExamplePropertyParser {
    public static final String META_FILE = "com.freescale.s32ds.cross.wizard.prefs";
    public static final String DESCRIPTION_FILE = "description.txt";
    public static final String GROUP_NAME_KEY = "groupName";
    public static final String SETTINGS_FOLDER = ".settings";
    public static final String WIZARD_VERSION_KEY = "wizardVersion";
    public static final String CORE_TYPE_KEY = "coreType";
    public static final String PROCESSOR = "processor";

    public static IExampleComponent parseToModelObject(File projectFile, String groupFolder) {
        Path path = new Path(projectFile.getAbsolutePath());
        ExampleComponent modelComponent = null;
        if (projectFile.exists()) {
            IProjectDescription projectDescription;
            block16: {
                projectDescription = ExampleProjectLoaderUtils.getProjectDescriptorByPath((IPath)path);
                if (projectDescription != null) break block16;
                return null;
            }
            try {
                IPath removeLastSegments = path.removeLastSegments(1);
                String strPathMeta = String.valueOf(removeLastSegments.toOSString()) + '/' + SETTINGS_FOLDER + '/' + META_FILE;
                List<String> descr = ExamplePropertyParser.findDescription(removeLastSegments);
                modelComponent = new ExampleComponent();
                modelComponent.setProjectName(projectDescription.getName());
                modelComponent.setId(projectDescription.getName());
                modelComponent.setGroup(groupFolder);
                Path pathMeta = new Path(strPathMeta);
                if (pathMeta.toFile().exists()) {
                    Properties prop = new Properties();
                    Throwable throwable = null;
                    Object var11_14 = null;
                    try (FileInputStream fileInput = new FileInputStream(strPathMeta);){
                        prop.load(fileInput);
                        modelComponent.setVersion(prop.getProperty(WIZARD_VERSION_KEY));
                        String propGroup = prop.getProperty(GROUP_NAME_KEY);
                        if (propGroup != null && !propGroup.isEmpty()) {
                            modelComponent.setId(propGroup);
                        }
                        modelComponent.setTarget(prop.getProperty(CORE_TYPE_KEY));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                modelComponent.setRelatedProjects(projectDescription.getReferencedProjects());
                modelComponent.setLocation(projectFile.getAbsolutePath());
                modelComponent.setDescription(descr);
                if (!descr.isEmpty()) {
                    modelComponent.setShortComment(descr.get(0));
                }
            }
            catch (IOException | CoreException e) {
                Status status = new Status(4, "com.nxp.s32ds.ext.cdt.examples.core", e.getMessage(), e);
                Log.log((IStatus)status);
            }
            return modelComponent;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> findDescription(IPath pathFile) throws CoreException {
        Object path;
        ArrayList<String> multiLineDescription = new ArrayList<String>();
        File descriptionFile = null;
        if (!pathFile.toFile().exists()) return multiLineDescription;
        descriptionFile = ExamplePropertyParser.findDescritionFile(pathFile);
        if (descriptionFile == null) {
            path = pathFile.removeLastSegments(1);
            descriptionFile = ExamplePropertyParser.findDescritionFile((IPath)path);
        }
        if (descriptionFile == null) return multiLineDescription;
        try {
            path = null;
            Object var4_6 = null;
            try {
                FileInputStream is = new FileInputStream(descriptionFile);
                try {
                    try (BufferedReader buf = new BufferedReader(new InputStreamReader(is));){
                        String line = buf.readLine();
                        while (line != null) {
                            multiLineDescription.add(line);
                            line = buf.readLine();
                        }
                    }
                    if (is == null) return multiLineDescription;
                }
                catch (Throwable throwable) {
                    if (path == null) {
                        path = throwable;
                    } else if (path != throwable) {
                        ((Throwable)path).addSuppressed(throwable);
                    }
                    if (is == null) throw path;
                    ((InputStream)is).close();
                    throw path;
                }
                ((InputStream)is).close();
                return multiLineDescription;
            }
            catch (Throwable throwable) {
                if (path == null) {
                    path = throwable;
                    throw path;
                } else {
                    if (path == throwable) throw path;
                    ((Throwable)path).addSuppressed(throwable);
                }
                throw path;
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "com.nxp.s32ds.ext.cdt.examples.core", e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private static File findDescritionFile(IPath pathFile) {
        File descriptionFile = null;
        File[] fileArray = pathFile.toFile().listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File iter = fileArray[n2];
            if (iter.getName().equals(DESCRIPTION_FILE)) {
                descriptionFile = iter;
                break;
            }
            ++n2;
        }
        return descriptionFile;
    }
}

