/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.internal.core.libs;

import com.nxp.s32ds.ext.rcp.variables.RcpVariables;
import com.nxp.s32ds.ext.rcp.variables.VariableManager;
import com.nxp.s32ds.mdt.vpt.apex2.core.vsdk.Apex2VsdkHelper;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.Apex2CoreActivator;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.libs.Messages;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import org.eclipse.osgi.util.NLS;

public class Apex2KernelHelper {
    public static final UnaryOperator<String> ARTIFACT_NAMES_OPERATOR = name -> ":" + name;

    public static UnaryOperator<String> getBlockSourcesOperator() {
        return Apex2VsdkHelper.getInstance().getBlockSourcesOperator();
    }

    public static UnaryOperator<String> getApuArtifactPathsOperator() {
        return Apex2VsdkHelper.getInstance().getApuArtifactPathsOperator();
    }

    public static UnaryOperator<String> getEmuArtifactPathsOperator() {
        return Apex2VsdkHelper.getInstance().getEmuArtifactPathsOperator();
    }

    public static List<String> getArtifactNames(String category) {
        List<String> names = Apex2KernelHelper.getApuArtifactNames(category);
        names.addAll(Apex2KernelHelper.getEmuArtifactNames(category));
        return names;
    }

    private static List<String> getApuArtifactNames(String category) {
        Apex2VsdkHelper helper = Apex2VsdkHelper.getInstance();
        return Apex2KernelHelper.getCommonArtifactNames(category, helper.getCompiledResApuFolder(), null);
    }

    private static List<String> getEmuArtifactNames(String category) {
        Apex2VsdkHelper helper = Apex2VsdkHelper.getInstance();
        return Apex2KernelHelper.getCommonArtifactNames(category, helper.getCompiledResEmuFolder(), helper.getCompiledResEmuLibPrefix());
    }

    private static List<String> getCommonArtifactNames(String category, String folder, String prefix) {
        try {
            ArrayList<String> names = new ArrayList<String>();
            Apex2VsdkHelper vsdkHelper = Apex2VsdkHelper.getInstance();
            String fullPath = RcpVariables.INSTANCE.relativize(vsdkHelper.getVsdkVariable(), String.valueOf(vsdkHelper.getInternalKernelsPath()) + vsdkHelper.getSeparator() + category + vsdkHelper.getSeparator() + folder);
            String resolvedPath = VariableManager.INSTANCE.performSubstitution(fullPath);
            Path path = Paths.get(resolvedPath, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Apex2CoreActivator.getInstance().logWarning(NLS.bind((String)Messages.Apex2KernelHelper_warning_folder_not_found, (Object)path));
                return Collections.emptyList();
            }
            Throwable throwable = null;
            Object var9_12 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, vsdkHelper.getLibraryPattern());){
                stream.forEach(f -> {
                    String name = f.getFileName().toString();
                    if (!name.endsWith("acf.a") && (prefix == null || name.startsWith(prefix))) {
                        names.add(name);
                    }
                });
                return names;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Apex2CoreActivator.getInstance().logError(Messages.Apex2KernelHelper_error_collecting_kernel_artifacts, e);
            return Collections.emptyList();
        }
    }
}

