/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.internal.core.launch;

import com.nxp.s32ds.cle.ide.core.listener.ComponentChangeEvent;
import com.nxp.s32ds.cle.ide.core.listener.ComponentListenerManager;
import com.nxp.s32ds.ext.emf.ecore.EObjects;
import com.nxp.s32ds.ext.emf.ecore.EmfResources;
import com.nxp.s32ds.ext.orbit.strings.SeparatedStrings;
import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apuprogram.ApuProcess;
import com.nxp.s32ds.gte.apuprogram.ApuProgram;
import com.nxp.s32ds.mdt.ide.launch.core.MdtLaunchConfigSupports;
import com.nxp.s32ds.mdt.vpt.apex2.core.converter.Apex2PluginVsdkUriConverter;
import com.nxp.s32ds.mdt.vpt.apex2.core.launch.Apex2LaunchParams;
import com.nxp.s32ds.mdt.vpt.apex2.core.launch.Apex2LaunchUtil;
import com.nxp.s32ds.mdt.vpt.apex2.core.launch.Apex2SourceType;
import com.nxp.s32ds.mdt.vpt.apex2.core.libs.Apex2KernelLibInformationCollector;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.Apex2CoreActivator;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public class Apex2LaunchDelegateUtil {
    public static EObject load(IFile sourcePath, Apex2SourceType sourceType) throws CoreException {
        URI uri = URI.createPlatformResourceURI((String)sourcePath.getFullPath().toString(), (boolean)true);
        List load = EmfResources.load((URI)uri);
        IPath iSourcePath = sourcePath.getFullPath();
        switch (sourceType) {
            case PROGRAM: {
                ApuProgram program = (ApuProgram)EObjects.firstOrNull((Collection)load, ApuProgram.class);
                if (program == null) {
                    throw Apex2CoreActivator.abort(NLS.bind((String)Messages.Apex2LaunchDelegateUtil_cannot_load_apex2_program_from_0, (Object)iSourcePath));
                }
                Apex2PluginVsdkUriConverter.resolveProgram(program);
                return program;
            }
            case GRAPH: {
                ApuGraph graph = (ApuGraph)EObjects.firstOrNull((Collection)load, ApuGraph.class);
                if (graph == null) {
                    throw Apex2CoreActivator.abort(NLS.bind((String)Messages.Apex2LaunchDelegateUtil_cannot_load_graph, (Object)iSourcePath));
                }
                Apex2PluginVsdkUriConverter.resolveGraph(graph);
                return graph;
            }
        }
        throw Apex2CoreActivator.abort(NLS.bind((String)Messages.Apex2LaunchDelegateUtil_cannot_load_source, (Object)iSourcePath));
    }

    public static void doPostGenerate(Apex2LaunchParams params, IProject project) throws CoreException {
        SeparatedStrings ss;
        String[] pathSegments;
        IStatus status;
        if (params == null) {
            return;
        }
        Apex2LaunchUtil.getOutput(params.getOutputPath());
        IFile sourcePath = Apex2LaunchUtil.getModelFile(params.getSourcePath(), params.getSourceType());
        EObject source = Apex2LaunchDelegateUtil.load(sourcePath, params.getSourceType());
        String path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(params.getOutputPath());
        IProject modelingProject = sourcePath.getProject();
        if (!project.equals((Object)modelingProject) && !(status = MdtLaunchConfigSupports.createLaunchConfigSupport((IProject)project, (EObject)source, Apex2LaunchDelegateUtil.getGraphNames(source), null)).isOK()) {
            Apex2CoreActivator.getInstance().log(status);
        }
        if ((pathSegments = (ss = new SeparatedStrings((CharSequence)"/")).asArray(path = path.replace("\\", "/"))).length == 0) {
            Apex2CoreActivator.getInstance().logError(Messages.Apex2GenLaunchDelegate_target_project_empty);
            return;
        }
        Apex2LaunchDelegateUtil.notifyComponentChange(sourcePath, source, pathSegments[pathSegments.length - 1]);
    }

    private static void notifyComponentChange(IFile sourcePath, EObject source, String targetProjectName) {
        String sourceProjectName = sourcePath.getProject().getName();
        if (sourceProjectName.equals(targetProjectName)) {
            return;
        }
        Set<Object> graphs = new HashSet<ApuGraph>();
        if (source instanceof ApuProgram) {
            graphs = ((ApuProgram)source).getProcesses().stream().map(p -> p.getGraph()).collect(Collectors.toSet());
        }
        if (source instanceof ApuGraph) {
            graphs.add((ApuGraph)source);
        }
        ArrayList<String> availableKernelsArchetypes = new ArrayList<String>(Arrays.asList("apex_kernel_vsdk_root"));
        graphs.forEach(g -> {
            ComponentChangeEvent event = new Apex2KernelLibInformationCollector((ApuGraph)g, g.getName(), targetProjectName, sourceProjectName, (List<String>)availableKernelsArchetypes).createComponentChangeEvent();
            ComponentListenerManager.INSTANCE.notifyComponentChange(event);
        });
    }

    private static Set<String> getGraphNames(EObject source) {
        if (source instanceof ApuProgram) {
            ApuProgram program = (ApuProgram)source;
            HashSet<String> names = new HashSet<String>();
            for (ApuProcess process : program.getProcesses()) {
                names.add(process.getGraph().getName());
            }
            return names;
        }
        if (source instanceof ApuGraph) {
            return Collections.singleton(((ApuGraph)source).getName());
        }
        return Collections.emptySet();
    }
}

