/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.internal.core.launch;

import com.nxp.s32ds.ext.emf.validation.EmfValidation;
import com.nxp.s32ds.ext.ide.externaltools.ExternalToolsLaunchDelegate;
import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.ApuKernel;
import com.nxp.s32ds.gte.apuprogram.ApuProcess;
import com.nxp.s32ds.mdt.ide.launch.core.BuildParticipant;
import com.nxp.s32ds.mdt.ide.launch.core.MdtLaunchDelegate;
import com.nxp.s32ds.mdt.ide.launch.core.MdtLaunchParams;
import com.nxp.s32ds.mdt.vpt.apex2.core.launch.Apex2LaunchConfigurationUtil;
import com.nxp.s32ds.mdt.vpt.apex2.core.launch.Apex2LaunchParams;
import com.nxp.s32ds.mdt.vpt.apex2.core.launch.Apex2LaunchUtil;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.Apex2CoreActivator;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.launch.Apex2LaunchDelegateUtil;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.launch.Messages;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public class Apex2GenLaunchDelegate
extends ExternalToolsLaunchDelegate
implements BuildParticipant,
MdtLaunchDelegate {
    private static final String STATIC_FILE_NAME = "apu_app_config.cpp";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        boolean codeEmitFinished = false;
        Apex2LaunchParams params = Apex2LaunchParams.getParams(configuration);
        Apex2LaunchUtil.getOutput(params.getOutputPath());
        IFile sourcePath = Apex2LaunchUtil.getModelFile(params.getSourcePath(), params.getSourceType());
        EObject source = Apex2LaunchDelegateUtil.load(sourcePath, params.getSourceType());
        String path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(params.getOutputPath());
        try {
            switch (mode) {
                case "emit": {
                    if (!EmfValidation.validate((EObject)source) || monitor.isCanceled()) {
                        return;
                    }
                    if (this.launchGeneration(configuration, mode, launch, monitor, params)) {
                        codeEmitFinished = true;
                        this.showFinish();
                    }
                    return;
                }
                case "emit_build": {
                    if (monitor.isCanceled()) {
                        throw Apex2CoreActivator.cancel();
                    }
                    if (!Apex2GenLaunchDelegate.modelModified(source, String.valueOf(path) + File.separator + params.getHostDir()) || !Apex2GenLaunchDelegate.modelModified(source, String.valueOf(path) + File.separator + params.getTestDir())) {
                        return;
                    }
                    if (!EmfValidation.validate((EObject)source) || monitor.isCanceled()) {
                        throw Apex2CoreActivator.cancel();
                    }
                    if (!this.launchGeneration(configuration, mode, launch, monitor, params)) {
                        throw Apex2CoreActivator.cancel();
                    }
                    codeEmitFinished = true;
                    return;
                }
            }
            return;
        }
        finally {
            if (codeEmitFinished) {
                IProject project = this.getTargetProject(configuration);
                if (project == null) {
                    Apex2CoreActivator.getInstance().logWarning(Messages.Apex2GenLaunchDelegate_invalid_launch_cfg);
                    return;
                }
                this.doPostGenerate(params, project, source, monitor);
            }
        }
    }

    public void doPostGenerate(MdtLaunchParams parameters, IProject project, EObject eObject, IProgressMonitor monitor) throws CoreException {
        Apex2LaunchParams params = (Apex2LaunchParams)parameters;
        Apex2LaunchDelegateUtil.doPostGenerate(params, project);
    }

    private boolean launchGeneration(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor, Apex2LaunchParams params) throws CoreException {
        ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
        Apex2LaunchConfigurationUtil.getInstance().applyExternalToolAtributes(workingCopy, params);
        super.launch((ILaunchConfiguration)workingCopy, mode, launch, monitor);
        if (monitor.isCanceled()) {
            return false;
        }
        IProject project = this.getTargetProject(configuration);
        if (project != null) {
            this.postGenerate(project, monitor);
        } else {
            Apex2CoreActivator.getInstance().logWarning(Messages.Apex2GenLaunchDelegate_invalid_launch_cfg);
        }
        return true;
    }

    private static boolean modelModified(EObject source, String genDir) {
        TreeIterator it = source.eAllContents();
        HashSet<URI> allObjectsURIs = new HashSet<URI>();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof ApuProcess)) continue;
            ApuProcess aProcess = (ApuProcess)obj;
            ApuGraph aGraph = aProcess.getGraph();
            if (aProcess.eResource() != null && aProcess.eResource().getURI() != null) {
                allObjectsURIs.add(aProcess.eResource().getURI());
            }
            if (aGraph == null || aGraph.eResource() == null || aGraph.eResource().getURI() == null) continue;
            allObjectsURIs.add(aGraph.eResource().getURI());
            allObjectsURIs.addAll(Apex2GenLaunchDelegate.findKernels(aGraph));
        }
        long lastModelMillis = 0L;
        for (URI uri : allObjectsURIs) {
            if (!uri.isPlatformResource()) continue;
            String platformString = uri.toPlatformString(true);
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
            if (res == null) continue;
            File file = res.getLocation().toFile();
            lastModelMillis = Math.max(lastModelMillis, file.lastModified());
        }
        String staticFile = genDir + File.separator + STATIC_FILE_NAME;
        File stFile = new File(staticFile);
        long lastSourceMillis = stFile.lastModified();
        return lastModelMillis > lastSourceMillis;
    }

    private static Set<URI> findKernels(ApuGraph aGraph) {
        HashSet<URI> result = new HashSet<URI>();
        for (ApuKernel kernel : aGraph.getKernels()) {
            if (kernel == null || kernel.eResource().getURI() == null) continue;
            result.add(kernel.getKernelInfo().eResource().getURI());
        }
        return result;
    }

    public void clean(IProject project, ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
    }

    public IFile getModelFileFromConfig(ILaunchConfiguration config) throws CoreException {
        Apex2LaunchParams params = Apex2LaunchParams.getParams(config);
        return Apex2LaunchUtil.getModelFile(params.getSourcePath(), params.getSourceType());
    }
}

