/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.internal.core;

import com.nxp.s32ds.ext.emf.ecore.EmfResources;
import com.nxp.s32ds.ext.emf.ecore.semantic.SimplePackageDelegate;
import com.nxp.s32ds.gte.apuprogram.ApuProgram;
import com.nxp.s32ds.gte.apuprogram.ApuProgramPackage;
import com.nxp.s32ds.mdt.vpt.apex2.core.converter.Apex2PluginVsdkUriConverter;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.Apex2CoreActivator;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.Apex2ProgramExtractor;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.osgi.framework.Version;

public class Apex2ProgramPackageDelegate
extends SimplePackageDelegate {
    private final Apex2ProgramExtractor extractor = new Apex2ProgramExtractor();
    private static final Version currentVersion = new Version(1, 0, 0);

    public Apex2ProgramPackageDelegate() {
        super((EPackage)ApuProgramPackage.eINSTANCE);
    }

    public EObject getSemanticRoot(EObject eObject) {
        return this.extractor.extract(eObject);
    }

    public Version getModelVersion(EObject eObject) {
        EObject root = this.getSemanticRoot(eObject);
        Version version = Version.emptyVersion;
        if (root instanceof ApuProgram) {
            ApuProgram program = (ApuProgram)root;
            version = new Version(program.getVersion());
        }
        return version;
    }

    public Version getCurrentVersion() {
        return currentVersion;
    }

    public void setModelVersion(EObject eObject, Version newVersion) {
        EObject root = this.getSemanticRoot(eObject);
        if (root instanceof ApuProgram) {
            ApuProgram program = (ApuProgram)root;
            program.setVersion(newVersion.toString());
        }
    }

    public IStatus convertModel(EObject eObject) {
        if (eObject instanceof ApuProgram) {
            ApuProgram program = (ApuProgram)eObject;
            Apex2PluginVsdkUriConverter.resolveProgram(program);
            EmfResources.save((URI)program.eResource().getURI(), (EObject)program);
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus validateVersion(EObject eObject) {
        if (!(eObject instanceof ApuProgram)) {
            return Apex2CoreActivator.getInstance().createError(Messages.notApexProgram);
        }
        ApuProgram program = (ApuProgram)eObject;
        Version programVersion = this.getModelVersion((EObject)program);
        if (programVersion.equals((Object)Version.emptyVersion)) {
            return Apex2CoreActivator.getInstance().createError(Messages.kernelURIsConversionNeeded);
        }
        return Status.OK_STATUS;
    }
}

