/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.internal.core;

import com.nxp.s32ds.ext.emf.ecore.EmfResources;
import com.nxp.s32ds.ext.emf.ecore.semantic.SimplePackageDelegate;
import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.ApuGraphPackage;
import com.nxp.s32ds.mdt.vpt.apex2.core.converter.Apex2PluginVsdkUriConverter;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.Apex2CoreActivator;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.Apex2GraphExtractor;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.osgi.framework.Version;

public class Apex2GraphPackageDelegate
extends SimplePackageDelegate {
    private final Apex2GraphExtractor extractor = new Apex2GraphExtractor();
    private static final Version currentVersion = new Version(1, 0, 0);

    public Apex2GraphPackageDelegate() {
        super((EPackage)ApuGraphPackage.eINSTANCE);
    }

    public EObject getSemanticRoot(EObject eObject) {
        return this.extractor.extract(eObject);
    }

    public Version getModelVersion(EObject eObject) {
        EObject root = this.getSemanticRoot(eObject);
        Version version = Version.emptyVersion;
        if (root instanceof ApuGraph) {
            ApuGraph graph = (ApuGraph)root;
            version = new Version(graph.getVersion());
        }
        return version;
    }

    public Version getCurrentVersion() {
        return currentVersion;
    }

    public void setModelVersion(EObject eObject, Version newVersion) {
        EObject root = this.getSemanticRoot(eObject);
        if (root instanceof ApuGraph) {
            ApuGraph graph = (ApuGraph)root;
            graph.setVersion(newVersion.toString());
        }
    }

    public IStatus convertModel(EObject eObject) {
        if (eObject instanceof ApuGraph) {
            ApuGraph graph = (ApuGraph)eObject;
            Apex2PluginVsdkUriConverter.resolveGraph(graph);
            EmfResources.save((URI)graph.eResource().getURI(), (EObject)graph);
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus validateVersion(EObject eObject) {
        if (!(eObject instanceof ApuGraph)) {
            return Apex2CoreActivator.getInstance().createError(Messages.notApexGraph);
        }
        ApuGraph graph = (ApuGraph)eObject;
        Version graphVersion = this.getModelVersion((EObject)graph);
        if (graphVersion.equals((Object)Version.emptyVersion)) {
            return Apex2CoreActivator.getInstance().createError(Messages.kernelURIsConversionNeeded);
        }
        return Status.OK_STATUS;
    }
}

