/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.core.vsdk;

import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.ApuGraphs;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelSource;
import com.nxp.s32ds.mdt.vpt.apex2.kernel.registry.Apex2KernelRegistryManager;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;

public class VsdkKernels {
    public static Set<ApuKernelInfo> getKernelInfos(Object o) {
        LinkedHashSet<ApuKernelInfo> result = new LinkedHashSet<ApuKernelInfo>();
        if (o instanceof ApuGraph) {
            ApuGraph graph = (ApuGraph)o;
            EList kernelInfos = ApuGraphs.getKernelInfos((ApuGraph)graph);
            result.addAll((Collection<ApuKernelInfo>)kernelInfos);
        }
        return result;
    }

    public static Set<String> getVsdkKernelCategories(Set<ApuKernelInfo> kernelInfos) {
        Set<String> result = kernelInfos.stream().filter(ki -> VsdkKernels.isKernelInfoFromVsdk(ki)).map(ki -> ki.getSource().getCategory()).collect(Collectors.toSet());
        return result;
    }

    public static Set<String> getVsdkCategoriesSet(Object o) {
        Set<ApuKernelInfo> kernelInfos = VsdkKernels.collectKernelInfosFromObject(o);
        return VsdkKernels.getVsdkKernelCategories(kernelInfos);
    }

    public static Set<String> getUserCategoriesSet(Object o) {
        Set<ApuKernelInfo> kernelInfos = VsdkKernels.collectKernelInfosFromObject(o);
        return VsdkKernels.getUserKernelCategories(kernelInfos);
    }

    public static Set<ApuKernelInfo> collectKernelInfos(Set<ApuGraph> graphs) {
        LinkedHashSet<ApuKernelInfo> kernelInfos = new LinkedHashSet<ApuKernelInfo>();
        graphs.forEach(g -> kernelInfos.addAll(VsdkKernels.getKernelInfos(g)));
        return kernelInfos;
    }

    public static Set<String> getUserKernelCategories(Set<ApuKernelInfo> kernelInfos) {
        Set<String> result = kernelInfos.stream().filter(ki -> VsdkKernels.isUserDefinedKernelInfo(ki)).map(ki -> ki.getSource().getCategory()).collect(Collectors.toSet());
        return result;
    }

    public static boolean isKernelInfoFromVsdk(ApuKernelInfo kernelInfo) {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            return VsdkKernels.findByOrigin(kernelInfo, "s32v234");
        }
        String archetypeId = Apex2KernelRegistryManager.INSTANCE.getArchetype(kernelInfo);
        return "apex_kernel_vsdk_root".equals(archetypeId);
    }

    public static boolean isUserDefinedKernelInfo(ApuKernelInfo kernelInfo) {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            return VsdkKernels.findByOrigin(kernelInfo, "workspace");
        }
        String archetypeId = Apex2KernelRegistryManager.INSTANCE.getArchetype(kernelInfo);
        return "apex_kernel_workspace_root".equals(archetypeId);
    }

    private static boolean findByOrigin(ApuKernelInfo kernelInfo, String id) {
        ApuKernelSource source = kernelInfo.getSource();
        return source != null && source.getOrigin().equals(id);
    }

    private static Set<ApuKernelInfo> collectKernelInfosFromObject(Object o) {
        if (!(o instanceof Set)) {
            return Collections.emptySet();
        }
        return VsdkKernels.collectKernelInfos((Set)o);
    }
}

