/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.core.vsdk;

import com.nxp.s32ds.ext.orbit.strings.SeparatedStrings;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.Apex2CoreActivator;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;

public class Apex2VsdkProperties {
    public static final String[] DEFAULT_AVAILABLE_KERNEL_FOLDERS = new String[]{"apexcv_base_", "sample_"};
    public static final String DEFAULT_SEPARATOR = "/";
    public static final String DEFAULT_VSDK_INTERNAL_KERNELS_PATH = "kernels/apu";
    public static final String DEFAULT_COMPILED_RESOURCES_APU_FOLDER = "build-apu-nxp-sa-d";
    public static final String DEFAULT_COMPILED_RESOURCES_EMU_FOLDER = Apex2VsdkProperties.getDefaultCompiledResEmuFolder();
    public static final String DEFAULT_COMPILED_RESOURCES_EMU_LIB_PREFIX = "lib";
    public static final String DEFAULT_SOURCE_FOLDER = "src";
    public static final String DEFAULT_PATTERN_C = ".c";
    public static final String DEFAULT_PATTERN_CPP = ".cpp";
    public static final String DEFAULT_PATTERN_IMPL = "_impl";
    public static final String DEFAULT_LIBRARY_PATTERN = "*.a";
    public static final String DEFAULT_VSDK_KERNELS_PATH = "APEX2/kernels/VSDK";
    private static final String KERNEL_FOLDERS_KEY = "apex2.available.kernel.folders";
    private static final String SEPARATOR_KEY = "apex2.separator";
    private static final String VSDK_INTERNAL_KERNELS_PATH_KEY = "apex2.sdk.internal.kernels.path";
    private static final String COMPILED_RESOURCES_APU_FOLDER_KEY = "apex2.compiled.resources.apu.folder";
    private static final String COMPILED_RESOURCES_EMU_FOLDER_KEY = "apex2.compiled.resources.emu.folder";
    private static final String COMPILED_RESOURCES_EMU_LIB_PREFIX_KEY = "apex2.compiled.resources.emu.lib.prefix";
    private static final String SOURCE_FOLDER_KEY = "apex2.source.folder";
    private static final String PATTERN_C_KEY = "apex2.pattern.c";
    private static final String PATTERN_CPP_KEY = "apex2.pattern.cpp";
    private static final String PATTERN_IMPL_KEY = "apex2.pattern.impl";
    private static final String LIBRARY_PATTERN_KEY = "apex2.library.pattern";
    private static final String VSDK_KERNELS_PATH_KEY = "apex2.vsdk.kernels";
    private String[] availableKernelFolders = DEFAULT_AVAILABLE_KERNEL_FOLDERS;
    private String separator = "/";
    private String internalKernelsPath = "kernels/apu";
    private String compiledResApuFolder = "build-apu-nxp-sa-d";
    private String compiledResEmuFolder = DEFAULT_COMPILED_RESOURCES_EMU_FOLDER;
    private String compiledResLibPrefix = "lib";
    private String src = "src";
    private String libraryPattern = "*.a";
    private String patternC = ".c";
    private String patternCpp = ".cpp";
    private String patternImpl = "_impl";
    private String vsdkKernelsPath = "APEX2/kernels/VSDK";

    public Apex2VsdkProperties() {
    }

    public Apex2VsdkProperties(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("Argument filename is null!");
        }
        this.readApex2VsdkProperties(filename);
    }

    private void readApex2VsdkProperties(String filename) {
        Properties props = new Properties();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream inStream = new FileInputStream(filename);){
                props.load(inStream);
                this.availableKernelFolders = Apex2VsdkProperties.readAvailableKernelFolders(props.getProperty(KERNEL_FOLDERS_KEY));
                this.separator = props.getProperty(SEPARATOR_KEY, DEFAULT_SEPARATOR);
                this.internalKernelsPath = props.getProperty(VSDK_INTERNAL_KERNELS_PATH_KEY, DEFAULT_VSDK_INTERNAL_KERNELS_PATH);
                this.compiledResApuFolder = props.getProperty(COMPILED_RESOURCES_APU_FOLDER_KEY, DEFAULT_COMPILED_RESOURCES_APU_FOLDER);
                this.compiledResEmuFolder = props.getProperty(COMPILED_RESOURCES_EMU_FOLDER_KEY, DEFAULT_COMPILED_RESOURCES_EMU_FOLDER);
                this.compiledResLibPrefix = props.getProperty(COMPILED_RESOURCES_EMU_LIB_PREFIX_KEY, DEFAULT_COMPILED_RESOURCES_EMU_LIB_PREFIX);
                this.src = props.getProperty(SOURCE_FOLDER_KEY, DEFAULT_SOURCE_FOLDER);
                this.libraryPattern = props.getProperty(LIBRARY_PATTERN_KEY, DEFAULT_LIBRARY_PATTERN);
                this.patternC = props.getProperty(PATTERN_C_KEY, DEFAULT_PATTERN_C);
                this.patternCpp = props.getProperty(PATTERN_CPP_KEY, DEFAULT_PATTERN_CPP);
                this.patternImpl = props.getProperty(PATTERN_IMPL_KEY, DEFAULT_PATTERN_IMPL);
                this.vsdkKernelsPath = props.getProperty(VSDK_KERNELS_PATH_KEY, DEFAULT_PATTERN_IMPL);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Apex2CoreActivator.getInstance().logError(e.getMessage(), e);
        }
    }

    private static String[] readAvailableKernelFolders(String value) {
        if (value != null && !value.isEmpty()) {
            return (String[])SeparatedStrings.COMMA_SEPARATED.asList(value).stream().map(s -> s.trim()).toArray(String[]::new);
        }
        return DEFAULT_AVAILABLE_KERNEL_FOLDERS;
    }

    public String[] getAvailableKernelFolders() {
        return this.availableKernelFolders;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getInternalKernelsPath() {
        return this.internalKernelsPath;
    }

    public String getPatternImpl() {
        return this.patternImpl;
    }

    public String getCompiledResApuFolder() {
        return this.compiledResApuFolder;
    }

    public String getCompiledResEmuFolder() {
        return this.compiledResEmuFolder;
    }

    public String getCompiledResLibPrefix() {
        return this.compiledResLibPrefix;
    }

    public String getSrc() {
        return this.src;
    }

    public String getLibraryPattern() {
        return this.libraryPattern;
    }

    public String getPatternC() {
        return this.patternC;
    }

    public String getPatternCpp() {
        return this.patternCpp;
    }

    public String getVsdkKernelsPath() {
        return this.vsdkKernelsPath;
    }

    private static String getDefaultCompiledResEmuFolder() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            return Platform.getOS().equals("win32") ? "build-x86-gnu-windows-d" : "build-x86-gnu-linux-d";
        }
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("win") ? "build-x86-gnu-windows-d" : "build-x86-gnu-linux-d";
    }
}

