/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.core.validation;

import com.nxp.s32ds.ext.emf.ecore.external.ExternalUriProtocol;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.Messages;
import com.nxp.s32ds.mdt.vpt.apex2.kernel.registry.Apex2KernelRegistryManager;
import java.util.List;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;

public class VsdkKernelNameExistsValidator
implements IValidator {
    private static IStatus ERROR_STATUS;

    public IStatus validate(Object value) {
        return VsdkKernelNameExistsValidator.validateObject(value);
    }

    private static IStatus validateObject(Object value) {
        if (value instanceof String) {
            return VsdkKernelNameExistsValidator.validateString((String)value);
        }
        if (value instanceof ApuKernelInfo) {
            return VsdkKernelNameExistsValidator.validateKernelInfo((ApuKernelInfo)value);
        }
        return Status.CANCEL_STATUS;
    }

    private static IStatus validateString(String name) {
        List vsdkKernels = Apex2KernelRegistryManager.INSTANCE.getKernelInfosByArchetype("apex_kernel_vsdk_root");
        boolean containsName = vsdkKernels.stream().anyMatch(ki -> name.equals(ki.getName()));
        if (!containsName) {
            return Status.OK_STATUS;
        }
        return VsdkKernelNameExistsValidator.getErrorStatus();
    }

    private static IStatus validateKernelInfo(ApuKernelInfo info) {
        URI kernelWithTheSameNameUri;
        if ("apex_kernel_vsdk_root".equals(Apex2KernelRegistryManager.INSTANCE.getArchetype(info))) {
            return Status.OK_STATUS;
        }
        List vsdkKernels = Apex2KernelRegistryManager.INSTANCE.getKernelInfosByArchetype("apex_kernel_vsdk_root");
        String name = info.getName();
        String category = info.getSource().getCategory();
        ApuKernelInfo kernelWithTheSameName = vsdkKernels.stream().filter(ki -> name.equals(ki.getName()) && category.equals(ki.getSource().getCategory())).findFirst().orElse(null);
        if (kernelWithTheSameName == null) {
            return Status.OK_STATUS;
        }
        URI infoUri = ExternalUriProtocol.resolve((URI)info.eResource().getURI());
        if (infoUri.equals(kernelWithTheSameNameUri = ExternalUriProtocol.resolve((URI)kernelWithTheSameName.eResource().getURI()))) {
            return Status.OK_STATUS;
        }
        return VsdkKernelNameExistsValidator.getErrorStatus();
    }

    private static IStatus getErrorStatus() {
        if (ERROR_STATUS == null) {
            ERROR_STATUS = new Status(4, "com.nxp.s32ds.mdt.vpt.apex2.core", Messages.VsdkKernelNameExistsValidator_vsdk_contsains_the_same_name);
        }
        return ERROR_STATUS;
    }
}

