/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.core.usages;

import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.ApuKernel;
import com.nxp.s32ds.gte.apugraph.registry.ApuGraphOrigin;
import com.nxp.s32ds.gte.apugraph.registry.ApuGraphRegistry;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.mdt.ide.core.usages.SemanticUsagesFinder;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;

public class Apex2KernelUsagesFinder
implements SemanticUsagesFinder {
    public List<EObject> find(EObject eObject, IProgressMonitor monitor) {
        if (!(eObject instanceof ApuKernelInfo)) {
            return new ArrayList<EObject>();
        }
        return this.getGraphsWithKernel((ApuKernelInfo)eObject, monitor);
    }

    public boolean isApplicable(EObject eObject) {
        return eObject instanceof ApuKernelInfo;
    }

    public List<EObject> getGraphsWithKernel(ApuKernelInfo kernelInfo, IProgressMonitor monitor) {
        List origins = ApuGraphRegistry.getGraphOrigins();
        for (ApuGraphOrigin origin : origins) {
            if (origin == null) continue;
            monitor.subTask(NLS.bind((String)Messages.Apex2KernelUsagesFinder_loading_origin, (Object)origin.getName()));
            origin.dispose();
            origin.load(monitor);
        }
        List srcList = ApuGraphRegistry.getGraphs();
        monitor.subTask(Messages.Apex2KernelUsagesFinder_filtering_graphs);
        return this.filterGraphs(kernelInfo, srcList);
    }

    public List<EObject> filterGraphs(ApuKernelInfo ki, List<ApuGraph> srcList) {
        ArrayList<EObject> dstList = new ArrayList<EObject>();
        block0: for (ApuGraph graph : srcList) {
            EList kernels = graph.getKernels();
            for (ApuKernel k : kernels) {
                ApuKernelInfo info = k.getKernelInfo();
                if (info == null) continue;
                if (!EcoreUtil.getURI((EObject)ki).equals(EcoreUtil.getURI((EObject)info))) continue block0;
                dstList.add((EObject)graph);
                continue block0;
            }
        }
        return dstList;
    }
}

