/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.core.usages;

import com.nxp.s32ds.ext.emf.ecore.EmfResources;
import com.nxp.s32ds.ext.ide.resources.WorkspaceResources;
import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apuprogram.ApuProcess;
import com.nxp.s32ds.gte.apuprogram.ApuProgram;
import com.nxp.s32ds.mdt.ide.core.usages.SemanticUsagesFinder;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.Apex2CoreActivator;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class Apex2GraphUsagesFinder
implements SemanticUsagesFinder {
    public List<EObject> find(EObject eObject, IProgressMonitor monitor) {
        if (!(eObject instanceof ApuGraph)) {
            return new ArrayList<EObject>();
        }
        return this.getProgramsWithGraph((ApuGraph)eObject, monitor);
    }

    public boolean isApplicable(EObject eObject) {
        return eObject instanceof ApuGraph;
    }

    public List<EObject> getProgramsWithGraph(ApuGraph graph, IProgressMonitor monitor) {
        ArrayList files = new ArrayList();
        try {
            monitor.subTask(Messages.Apex2GraphUsagesFinder_loading_workspace_resources);
            List collected = WorkspaceResources.collectFiles((String[])new String[]{"apuprogram"});
            files.addAll(collected);
        }
        catch (CoreException e) {
            Apex2CoreActivator.getInstance().log(e.getStatus());
            return new ArrayList<EObject>();
        }
        ArrayList<ApuProgram> infos = new ArrayList<ApuProgram>();
        monitor.subTask(Messages.Apex2GraphUsagesFinder_reading_programs);
        ResourceSet rs = EmfResources.createResourceSet();
        for (IFile file : files) {
            URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            List contents = EmfResources.load((URI)uri, (ResourceSet)rs);
            for (EObject eObject : contents) {
                if (!(eObject instanceof ApuProgram)) continue;
                ApuProgram info = (ApuProgram)eObject;
                infos.add(info);
            }
        }
        monitor.subTask(Messages.Apex2GraphUsagesFinder_filtering_programs);
        return this.filterPrograms(graph, infos);
    }

    public List<EObject> filterPrograms(ApuGraph graph, List<ApuProgram> srcList) {
        ArrayList<EObject> dstList = new ArrayList<EObject>();
        block0: for (ApuProgram program : srcList) {
            EList processes = program.getProcesses();
            for (ApuProcess p : processes) {
                ApuGraph g = p.getGraph();
                if (g == null || !this.compareGraphs(g, graph)) continue;
                dstList.add((EObject)program);
                continue block0;
            }
        }
        return dstList;
    }

    private boolean compareGraphs(ApuGraph g1, ApuGraph g2) {
        String uri1 = EcoreUtil.getURI((EObject)g1).toString();
        String uri2 = EcoreUtil.getURI((EObject)g2).toString();
        uri1 = uri1.replaceAll(Pattern.quote("//"), "/");
        uri2 = uri2.replaceAll(Pattern.quote("//"), "/");
        return uri1.equals(uri2);
    }
}

