/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.core.libs;

import com.nxp.s32ds.cle.ide.core.listener.ComponentChangeEvent;
import com.nxp.s32ds.cle.ide.core.listener.builder.ComponentChangeEventBuilder;
import com.nxp.s32ds.cle.ide.core.listener.builder.ComponentChangePayload;
import com.nxp.s32ds.cle.ide.core.listener.builder.ComponentChangePayloadBuilder;
import com.nxp.s32ds.cle.runtime.component.registry.core.ComponentRegistryCore;
import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.mdt.vpt.apex2.core.vsdk.Apex2VsdkHelper;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.libs.Apex2KernelHelper;
import com.nxp.s32ds.mdt.vpt.apex2.kernel.registry.Apex2KernelBlockUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class Apex2KernelLibInformationCollector {
    public static final String ARCHETYPE_ID = "apex_kernel_library";
    private ApuGraph graph;
    private String componentId;
    private String targetComponentId;
    private String groupId;
    private List<String> availableArchetypes;
    private static Apex2VsdkHelper helper = Apex2VsdkHelper.getInstance();

    public Apex2KernelLibInformationCollector(ApuGraph graph, String componentId, String targetComponentId, String groupId, List<String> availableArchetypes) {
        this.graph = graph;
        this.componentId = componentId;
        this.targetComponentId = targetComponentId;
        this.groupId = groupId;
        this.availableArchetypes = availableArchetypes;
    }

    public ComponentChangeEvent createComponentChangeEvent() {
        ComponentChangeEvent event = ComponentChangeEventBuilder.builder().archetypeId(ARCHETYPE_ID).componentId(this.componentId).targetComponentId(this.targetComponentId).groupId(this.groupId).payload((Object)this.createPayload()).build();
        return event;
    }

    private ComponentChangePayload createPayload() {
        Set<String> categories = this.collectCategories();
        List<String> names = Apex2KernelLibInformationCollector.getArtifactNames(categories);
        List<String> paths = Apex2KernelLibInformationCollector.getArtifactPaths(categories);
        List<String> sources = Apex2KernelLibInformationCollector.getBlockSources(categories);
        ComponentChangePayload payload = ComponentChangePayloadBuilder.builder().artifactNames(names).artifactPaths(paths).blockURIs(sources).build();
        return payload;
    }

    private static List<String> getArtifactNames(Collection<String> categories) {
        ArrayList<String> names = new ArrayList<String>();
        for (String category : categories) {
            names.addAll(Apex2KernelHelper.getArtifactNames(category));
        }
        List<String> emuNames = Apex2KernelLibInformationCollector.toPrefixedStrings(names, "${BUILD_EMU_ARTIFACT}", helper.getCompiledResEmuLibPrefix());
        List<String> apuNames = Apex2KernelLibInformationCollector.toNotPrefixedStrings(names, "${BUILD_APU_ARTIFACT}", helper.getCompiledResEmuLibPrefix());
        ArrayList<String> allNames = new ArrayList<String>();
        allNames.addAll(apuNames);
        allNames.addAll(emuNames);
        return Apex2KernelLibInformationCollector.transform(allNames, Apex2KernelHelper.ARTIFACT_NAMES_OPERATOR);
    }

    private static List<String> getBlockSources(Collection<String> categories) {
        return Apex2KernelLibInformationCollector.transform(categories, Apex2KernelHelper.getBlockSourcesOperator());
    }

    private static List<String> getArtifactPaths(Collection<String> categories) {
        List<String> apuList = Apex2KernelLibInformationCollector.toPrefixedStringsWoFilter(Apex2KernelLibInformationCollector.transform(categories, Apex2KernelHelper.getApuArtifactPathsOperator()), "${BUILD_APU_ARTIFACT}");
        List<String> emuList = Apex2KernelLibInformationCollector.toPrefixedStringsWoFilter(Apex2KernelLibInformationCollector.transform(categories, Apex2KernelHelper.getEmuArtifactPathsOperator()), "${BUILD_EMU_ARTIFACT}");
        ArrayList<String> allList = new ArrayList<String>();
        allList.addAll(apuList);
        allList.addAll(emuList);
        return allList;
    }

    private static List<String> transform(Collection<String> categories, UnaryOperator<String> transformOperator) {
        return categories.stream().map(s -> (String)transformOperator.apply((String)s)).collect(Collectors.toList());
    }

    private static List<String> toPrefixedStrings(List<String> list, String prefix, String pattern) {
        return list.stream().filter(s -> s.startsWith(pattern)).map(s -> prefix.concat((String)s)).collect(Collectors.toList());
    }

    private static List<String> toNotPrefixedStrings(List<String> list, String prefix, String pattern) {
        return list.stream().filter(s -> !s.startsWith(pattern)).map(s -> prefix.concat((String)s)).collect(Collectors.toList());
    }

    private static List<String> toPrefixedStringsWoFilter(List<String> list, String prefix) {
        return list.stream().map(s -> prefix.concat((String)s)).collect(Collectors.toList());
    }

    private Set<String> collectCategories() {
        return this.graph.getKernels().stream().map(k -> k.getKernelInfo()).filter(k -> this.checkAvailableArchetypes((ApuKernelInfo)k)).map(k -> k.getSource().getCategory()).collect(Collectors.toSet());
    }

    private boolean checkAvailableArchetypes(ApuKernelInfo info) {
        if (this.availableArchetypes == null || this.availableArchetypes.isEmpty()) {
            return true;
        }
        String blockId = Apex2KernelBlockUtil.getBlockId((ApuKernelInfo)info);
        List descList = ComponentRegistryCore.getBlockRegistry().getBlockArchetypeDescriptorsByBlockId(blockId);
        return descList.stream().anyMatch(d -> this.availableArchetypes.contains(d.getArchetypeId()));
    }
}

