/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.core.launch;

import com.nxp.s32ds.ext.ide.resources.WorkspaceResources;
import com.nxp.s32ds.mdt.vpt.apex2.core.launch.Apex2SourceType;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.Apex2CoreActivator;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.Messages;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.launch.Apex2LaunchDelegateUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;

public class Apex2LaunchUtil {
    public static IPath getPath(String location) throws CoreException {
        if (location == null) {
            throw Apex2CoreActivator.abort(Messages.Apex2LaunchUtil_location_is_null);
        }
        if (location.trim().isEmpty()) {
            throw Apex2CoreActivator.abort(Messages.Apex2LaunchUtil_location_is_empty);
        }
        try {
            String expandedLocation = Apex2LaunchUtil.performStringSubstitution(location);
            if (!Files.isRegularFile(Paths.get(expandedLocation, new String[0]), new LinkOption[0])) {
                throw Apex2CoreActivator.abort(NLS.bind((String)Messages.Apex2LaunchUtil_the_file_0_does_not_exist, (Object)expandedLocation));
            }
            return new Path(expandedLocation);
        }
        catch (Exception e) {
            throw Apex2CoreActivator.abort(NLS.bind((String)Messages.Apex2LaunchUtil_cannot_build_path_0caused_by_1, (Object)location, (Object)e.getMessage()), e);
        }
    }

    public static IFile getModelFile(String location, Apex2SourceType type) throws CoreException {
        IFile file;
        if (location == null || location.isEmpty()) {
            switch (type) {
                case PROGRAM: {
                    throw Apex2CoreActivator.abort(Messages.Apex2LaunchUtil_path_to_program_is_not_defined);
                }
                case GRAPH: {
                    throw Apex2CoreActivator.abort(Messages.Apex2LaunchUtil_path_to_graph_is_not_defined);
                }
            }
            throw Apex2CoreActivator.abort(Messages.Apex2LaunchUtil_path_to_model_is_not_defined);
        }
        try {
            file = WorkspaceResources.getFile((IPath)new Path(location));
        }
        catch (Exception e) {
            throw Apex2CoreActivator.abort(NLS.bind((String)Messages.Apex2LaunchUtil_cannot_build_path_0caused_by_1, (Object)location, (Object)e.getMessage()), e);
        }
        if (!file.exists()) {
            switch (type) {
                case PROGRAM: {
                    throw Apex2CoreActivator.abort(NLS.bind((String)Messages.Apex2LaunchUtil_program_not_found, (Object)location));
                }
                case GRAPH: {
                    throw Apex2CoreActivator.abort(NLS.bind((String)Messages.Apex2LaunchUtil_graph_not_found, (Object)location));
                }
            }
            throw Apex2CoreActivator.abort(NLS.bind((String)Messages.Apex2LaunchUtil_model_not_found, (Object)location));
        }
        return file;
    }

    public static void checkModelFile(String location, Apex2SourceType type) throws CoreException {
        IFile file = Apex2LaunchUtil.getModelFile(location, type);
        Apex2LaunchDelegateUtil.load(file, type);
    }

    public static IPath getOutput(String location) throws CoreException {
        if (location == null || location.isEmpty()) {
            throw Apex2CoreActivator.abort(Messages.Apex2LaunchUtil_path_to_output_folder_is_not_defined);
        }
        try {
            String substitution = Apex2LaunchUtil.performStringSubstitution(location);
            java.nio.file.Path path = Paths.get(substitution, new String[0]);
            if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
                throw Apex2CoreActivator.abort(Messages.Apex2LaunchUtil_output_should_be_a_directory);
            }
            return new Path(substitution);
        }
        catch (Exception e) {
            throw Apex2CoreActivator.abort(NLS.bind((String)Messages.Apex2LaunchUtil_cannot_build_path_0caused_by_1, (Object)location, (Object)e.getMessage()), e);
        }
    }

    private static String performStringSubstitution(String output) throws CoreException {
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(output);
    }
}

