/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.core.launch;

import com.nxp.s32ds.mdt.ide.core.MdtIdeCore;
import com.nxp.s32ds.mdt.ide.launch.core.MdtLaunchParams;
import com.nxp.s32ds.mdt.vpt.apex2.clt.cli.Apex2CliBuilder;
import com.nxp.s32ds.mdt.vpt.apex2.core.launch.Apex2LaunchDefaultParams;
import com.nxp.s32ds.mdt.vpt.apex2.core.launch.Apex2SourceType;
import com.nxp.s32ds.mdt.vpt.apex2.core.vsdk.Apex2VsdkHelper;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.Apex2CoreActivator;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.launch.Messages;
import com.nxp.s32ds.mdt.vpt.apex2.kernel.external.Apex2ExternalKernelConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class Apex2LaunchParams
extends MdtLaunchParams {
    private String outputPath = "";
    private String sourcePath = "";
    private Apex2SourceType sourceType = Apex2LaunchDefaultParams.DEFAULT_SOURCE_TYPE;
    private boolean emitHost = false;
    private boolean emitTest = false;
    private boolean emitKernel = true;
    private boolean emitGraph = true;
    private String kernelDir = "APU_kernels";
    private String graphDir = "graphs";
    private String hostDir = "A53_gen";
    private String testDir = "A53_test";
    private boolean validate = false;
    private boolean ignoreValidationResult = true;
    private static final Apex2LaunchParams DEFAULT_INSTANCE = new Apex2LaunchParams();
    private static final String PROGRAM_PATH = "com.nxp.s32ds.mdt.vpt.apex2.core.program_path";
    private static final String SOURCE_PATH = "com.nxp.s32ds.mdt.vpt.apex2.core.source_path";
    private static final String SOURCE_TYPE = "com.nxp.s32ds.mdt.vpt.apex2.core.source_type";
    private static final String OUTPUT_PATH = "com.nxp.s32ds.mdt.vpt.apex2.core.output_path";
    private static final String VALIDATE = "com.nxp.s32ds.mdt.vpt.apex2.core.validate";
    private static final String IGNORE_VALIDATION_RESULTS = "com.nxp.s32ds.mdt.vpt.apex2.core.ignoreValidationResult";
    private static final String EMIT_HOST = "com.nxp.s32ds.mdt.vpt.apex2.core.emit_host";
    private static final String EMIT_KERNEL = "com.nxp.s32ds.mdt.vpt.apex2.core.emit_kernel";
    private static final String EMIT_GRAPH = "com.nxp.s32ds.mdt.vpt.apex2.core.emit_graph";
    private static final String EMIT_TEST = "com.nxp.s32ds.mdt.vpt.apex2.core.emit_test";
    private static final String GRAPH_DIR = "com.nxp.s32ds.mdt.vpt.apex2.core.graph_dir";
    private static final String KERNEL_DIR = "com.nxp.s32ds.mdt.vpt.apex2.core.kernel_dir";
    private static final String HOST_DIR = "com.nxp.s32ds.mdt.vpt.apex2.core.host_dir";
    private static final String TEST_DIR = "com.nxp.s32ds.mdt.vpt.apex2.core.test_dir";

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public Apex2SourceType getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(Apex2SourceType sourceType) {
        this.sourceType = sourceType;
    }

    public boolean isEmitHost() {
        return this.emitHost;
    }

    public void setEmitHost(boolean generateHost) {
        this.emitHost = generateHost;
    }

    public boolean isEmitTest() {
        return this.emitTest;
    }

    public void setEmitTest(boolean generateTest) {
        this.emitTest = generateTest;
    }

    public boolean isEmitKernel() {
        return this.emitKernel;
    }

    public void setEmitKernel(boolean emitKernel) {
        this.emitKernel = emitKernel;
    }

    public boolean isEmitGraph() {
        return this.emitGraph;
    }

    public void setEmitGraph(boolean emitGraph) {
        this.emitGraph = emitGraph;
    }

    public String getKernelDir() {
        return this.kernelDir;
    }

    public void setKernelDir(String kernelDir) {
        this.kernelDir = kernelDir;
    }

    public String getGraphDir() {
        return this.graphDir;
    }

    public void setGraphDir(String graphDir) {
        this.graphDir = graphDir;
    }

    public String getHostDir() {
        return this.hostDir;
    }

    public void setHostDir(String hostDir) {
        this.hostDir = hostDir;
    }

    public String getTestDir() {
        return this.testDir;
    }

    public void setTestDir(String testDir) {
        this.testDir = testDir;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public boolean isIgnoreValidationResult() {
        return this.ignoreValidationResult;
    }

    public void setIgnoreValidationResult(boolean ignoreValidationResult) {
        this.ignoreValidationResult = ignoreValidationResult;
    }

    public static Apex2LaunchParams getParams(ILaunchConfiguration configuration) throws CoreException {
        Apex2LaunchParams params = new Apex2LaunchParams();
        String programPath = configuration.getAttribute(PROGRAM_PATH, null);
        params.setSourcePath(configuration.getAttribute(SOURCE_PATH, programPath == null ? "" : programPath));
        params.setEmitHost(configuration.getAttribute(EMIT_HOST, false));
        params.setSourceType(Apex2LaunchParams.safeGetSourceType(configuration.getAttribute(SOURCE_TYPE, Apex2LaunchDefaultParams.DEFAULT_SOURCE_TYPE.name())));
        params.setOutputPath(configuration.getAttribute(OUTPUT_PATH, ""));
        params.setEmitKernel(configuration.getAttribute(EMIT_KERNEL, true));
        params.setEmitGraph(configuration.getAttribute(EMIT_GRAPH, true));
        params.setEmitTest(configuration.getAttribute(EMIT_TEST, false));
        params.setHostDir(configuration.getAttribute(HOST_DIR, "A53_gen"));
        params.setTestDir(configuration.getAttribute(TEST_DIR, "A53_test"));
        params.setKernelDir(configuration.getAttribute(KERNEL_DIR, "APU_kernels"));
        params.setGraphDir(configuration.getAttribute(GRAPH_DIR, "graphs"));
        params.setValidate(configuration.getAttribute(VALIDATE, false));
        params.setIgnoreValidationResult(configuration.getAttribute(IGNORE_VALIDATION_RESULTS, true));
        return params;
    }

    private static Apex2SourceType safeGetSourceType(String type) {
        try {
            return Apex2SourceType.valueOf(type);
        }
        catch (Exception exception) {
            return Apex2SourceType.PROGRAM;
        }
    }

    public void applyParams(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(SOURCE_PATH, this.getSourcePath());
        configuration.setAttribute(EMIT_HOST, this.isEmitHost());
        configuration.setAttribute(SOURCE_TYPE, this.getSourceType().name());
        configuration.setAttribute(OUTPUT_PATH, this.getOutputPath());
        configuration.setAttribute(EMIT_KERNEL, this.isEmitKernel());
        configuration.setAttribute(EMIT_GRAPH, this.isEmitGraph());
        configuration.setAttribute(EMIT_TEST, this.isEmitTest());
        configuration.setAttribute(HOST_DIR, this.getHostDir());
        configuration.setAttribute(TEST_DIR, this.getTestDir());
        configuration.setAttribute(KERNEL_DIR, this.getKernelDir());
        configuration.setAttribute(GRAPH_DIR, this.getGraphDir());
        configuration.setAttribute(VALIDATE, this.isValidate());
        configuration.setAttribute(IGNORE_VALIDATION_RESULTS, this.isIgnoreValidationResult());
    }

    public static void applyDefaults(ILaunchConfigurationWorkingCopy workingCopy) {
        DEFAULT_INSTANCE.applyParams(workingCopy);
    }

    public String constructArgs() {
        switch (this.sourceType) {
            case PROGRAM: {
                return this.constructProgramArgs();
            }
            case GRAPH: {
                return this.constructGraphArgs();
            }
        }
        Apex2CoreActivator.getInstance().logError(Messages.Apex2LaunchParams_unknown_apex2_source_type);
        return "";
    }

    private String constructProgramArgs() {
        return ((Apex2CliBuilder)((Apex2CliBuilder)((Apex2CliBuilder)((Apex2CliBuilder)((Apex2CliBuilder)new Apex2CliBuilder().validate(this.isValidate())).ignoreValidationResult(this.isIgnoreValidationResult())).modelPath(MdtIdeCore.toWorkspaceVariabled((String)this.getSourcePath()))).outputDir(this.getOutputPath())).emitKernel(this.isEmitKernel()).kernelDir(this.getKernelDir()).emitGraph(this.isEmitGraph()).emitTest(this.isEmitTest()).graphDir(this.getGraphDir()).emitHost(this.isEmitHost()).hostDir(this.getHostDir()).testDir(this.getTestDir()).externalKernelsPath(Apex2ExternalKernelConstants.EXTERNAL_KERNELS_VARIABLE.getText()).extPath(Apex2VsdkHelper.getInstance().getVsdkExtVariable().getText())).buildArgsString();
    }

    private String constructGraphArgs() {
        return ((Apex2CliBuilder)((Apex2CliBuilder)((Apex2CliBuilder)((Apex2CliBuilder)((Apex2CliBuilder)new Apex2CliBuilder().validate(this.isValidate())).ignoreValidationResult(this.isIgnoreValidationResult())).modelPath(MdtIdeCore.toWorkspaceVariabled((String)this.getSourcePath()))).outputDir(this.getOutputPath())).emitKernel(this.isEmitKernel()).kernelDir(this.getKernelDir()).emitGraph(this.isEmitGraph()).graphDir(this.getGraphDir()).emitHost(false).emitTest(false).hostDir(this.getHostDir()).testDir(this.getTestDir()).externalKernelsPath(Apex2ExternalKernelConstants.EXTERNAL_KERNELS_VARIABLE.getText()).extPath(Apex2VsdkHelper.getInstance().getVsdkExtVariable().getText())).buildArgsString();
    }

    public String toString() {
        return "Apex2LaunchParams [outputPath=" + this.outputPath + ", sourcePath=" + this.sourcePath + ", sourceType=" + (Object)((Object)this.sourceType) + ", emitHost=" + this.emitHost + ", emitKernel=" + this.emitKernel + ", emitGraph=" + this.emitGraph + ", kernelDir=" + this.kernelDir + ", graphDir=" + this.graphDir + ", hostDir=" + this.hostDir + ", testDir=" + this.testDir + ", validate=" + this.validate + ", ignoreValidationResult=" + this.ignoreValidationResult + "]";
    }
}

