/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.core.launch;

import com.nxp.s32ds.gte.apugen.ApuGenModel;
import com.nxp.s32ds.gte.apuprogram.ApuProgram;
import com.nxp.s32ds.mdt.ide.core.MdtIdeCore;
import com.nxp.s32ds.mdt.ide.core.vsdk.MdtVsdkHelper;
import com.nxp.s32ds.mdt.ide.launch.core.MdtLaunchConfiguration;
import com.nxp.s32ds.mdt.vpt.apex2.core.launch.Apex2ConfigurationService;
import com.nxp.s32ds.mdt.vpt.apex2.core.launch.Apex2LaunchParams;
import com.nxp.s32ds.mdt.vpt.apex2.core.vsdk.Apex2VsdkHelper;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.Apex2CoreActivator;
import com.nxp.s32ds.mdt.vpt.apex2.internal.core.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public class Apex2LaunchConfigurationUtil
extends MdtLaunchConfiguration {
    public static final String CONFIGURATION_TYPE = "com.nxp.s32ds.mdt.vpt.apex2.core.apex2Emit";
    private static final Apex2LaunchConfigurationUtil INSTANCE = new Apex2LaunchConfigurationUtil();

    public static Apex2LaunchConfigurationUtil getInstance() {
        return INSTANCE;
    }

    private Apex2LaunchConfigurationUtil() {
        super("apex2");
    }

    protected MdtVsdkHelper getVsdkHelper() {
        return Apex2VsdkHelper.getInstance();
    }

    public static ILaunchConfigurationWorkingCopy createConfiguration(IContainer container, String name) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(CONFIGURATION_TYPE);
        String dstName = manager.generateLaunchConfigurationName(name);
        ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(container, dstName);
        Apex2LaunchParams.applyDefaults(workingCopy);
        return workingCopy;
    }

    public static ILaunchConfigurationWorkingCopy createConfiguration(IContainer container, EObject semanticType) throws CoreException {
        ApuGenModel genModel;
        if (!(semanticType instanceof ApuProgram)) {
            throw Apex2CoreActivator.abort(Messages.Apex2Core_e_missed_apuprogram);
        }
        ApuProgram program = (ApuProgram)semanticType;
        IFile modelFile = MdtIdeCore.toWorkspaceFile((EObject)program);
        if (modelFile == null || !modelFile.exists()) {
            throw Apex2CoreActivator.abort(Messages.Apex2Launch_model_file_not_found);
        }
        IProject project = modelFile.getProject();
        String name = NLS.bind((String)Messages.Apex2Emitter_name_pattern, (Object)project.getName(), (Object)program.getName());
        ILaunchConfigurationWorkingCopy workingCopy = Apex2LaunchConfigurationUtil.createConfiguration(container, name);
        Apex2LaunchParams params = Apex2LaunchParams.getParams((ILaunchConfiguration)workingCopy);
        IProject tagetProject = project;
        if (container != null) {
            tagetProject = container.getProject();
        }
        if ((genModel = Apex2ConfigurationService.getGenModel(program)) != null) {
            params.setGraphDir(genModel.getGraphFolder());
            params.setHostDir(genModel.getSourceFolder());
            params.setKernelDir(genModel.getKernelFolder());
        }
        params.setOutputPath(MdtIdeCore.toWorkspaceVariabled((IResource)tagetProject));
        params.setSourcePath(modelFile.getFullPath().toPortableString());
        params.applyParams(workingCopy);
        return workingCopy;
    }
}

