/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.core.filter;

import com.nxp.s32ds.ext.emf.ecore.EmfResources;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.mdt.vpt.apex2.kernel.registry.Apex2KernelRegistryManager;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;

public class KernelDuplicateFilter {
    private Set<ApuKernelInfo> duplicates = null;
    private List<ApuKernelInfo> firstFoundCollection = new LinkedList<ApuKernelInfo>();
    private List<ApuKernelInfo> initialList;
    private Set<ApuKernelInfo> filter;

    public KernelDuplicateFilter(List<ApuKernelInfo> initialList, Set<ApuKernelInfo> filter) {
        this.initialList = initialList;
        this.filter = filter;
    }

    public List<ApuKernelInfo> getFilteredList() {
        this.prepareDuplicatesAndFindFirst();
        if (this.initialList == null) {
            return null;
        }
        List<ApuKernelInfo> finalList = this.initialList.stream().filter(k -> !this.duplicates.contains(k)).collect(Collectors.toList());
        return finalList;
    }

    private void prepareDuplicatesAndFindFirst() {
        if (this.initialList == null) {
            return;
        }
        if (this.duplicates == null || this.duplicates.isEmpty()) {
            this.prepareDuplicates();
        }
        this.duplicates.removeAll(this.findFirstCollection());
    }

    public Set<ApuKernelInfo> findHiddenDuplicatesInFilter() {
        this.prepareDuplicatesAndFindFirst();
        if (this.filter == null || this.filter.isEmpty()) {
            return new HashSet<ApuKernelInfo>();
        }
        Set<ApuKernelInfo> filteredDuplicatesOnDiagram = this.duplicates.stream().filter(d -> this.filter.stream().anyMatch(f -> d.getName().equals(f.getName()) && EmfResources.compareByAbsolutePath((EObject)f, (EObject)d))).collect(Collectors.toSet());
        return filteredDuplicatesOnDiagram;
    }

    public void prepareDuplicates() {
        if (this.initialList == null) {
            return;
        }
        Map<String, Long> countingMap = this.initialList.stream().collect(Collectors.groupingBy(ApuKernelInfo::getName, Collectors.counting()));
        this.duplicates = this.initialList.parallelStream().filter(k -> (Long)countingMap.get(k.getName()) > 1L).collect(Collectors.toSet());
        this.findFirstCollection();
    }

    private List<ApuKernelInfo> findFirstCollection() {
        if (!this.firstFoundCollection.isEmpty()) {
            return this.firstFoundCollection;
        }
        Comparator comparator = (k1, k2) -> k1.getSource().getCategory().compareTo(k2.getSource().getCategory());
        Map<String, List<ApuKernelInfo>> name2Duplicates = this.duplicates.stream().collect(Collectors.groupingBy(ApuKernelInfo::getName));
        name2Duplicates.values().forEach(dupl -> {
            ApuKernelInfo firstFound = KernelDuplicateFilter.findFirst(comparator, dupl);
            this.firstFoundCollection.add(firstFound);
        });
        return this.firstFoundCollection;
    }

    private static ApuKernelInfo findFirst(Comparator<ApuKernelInfo> comparator, List<ApuKernelInfo> dupl) {
        return dupl.stream().filter(k -> "apex_kernel_vsdk_root".equals(Apex2KernelRegistryManager.INSTANCE.getArchetype(k))).sorted(comparator).findFirst().orElse(dupl.stream().filter(k -> "apex_kernel_external_root".equals(Apex2KernelRegistryManager.INSTANCE.getArchetype(k))).sorted(comparator).findFirst().orElse(dupl.stream().filter(k -> "apex_kernel_workspace_root".equals(Apex2KernelRegistryManager.INSTANCE.getArchetype(k))).sorted(comparator).findFirst().orElse(null)));
    }

    public Set<ApuKernelInfo> getDuplicates() {
        return this.duplicates;
    }
}

