/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.core.converter;

import com.nxp.s32ds.ext.emf.ecore.external.ExternalUriProtocol;
import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.ApuKernel;
import com.nxp.s32ds.gte.apuprogram.ApuProgram;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class Apex2PluginVsdkUriConverter {
    private static final String APUKERNEL_S32V234_MODEL = "com.nxp.s32ds.gte.apukernel.s32v234/model";

    public static void resolveProgram(ApuProgram program) {
        program.getProcesses().stream().flatMap(proc -> proc.getGraph().getKernels().stream()).forEach(k -> Apex2PluginVsdkUriConverter.replaceOldVsdkUri(k));
    }

    public static void resolveGraph(ApuGraph graph) {
        graph.getKernels().forEach(k -> Apex2PluginVsdkUriConverter.replaceOldVsdkUri(k));
    }

    public static Object replaceOldVsdkUri(ApuKernel kernel) {
        InternalEObject internal = (InternalEObject)kernel.getKernelInfo();
        Apex2PluginVsdkUriConverter.replaceProxy(internal);
        EcoreUtil.resolveAll((EObject)kernel);
        Map map = EcoreUtil.UnresolvedProxyCrossReferencer.find((EObject)kernel);
        map.keySet().forEach(unresolved -> Apex2PluginVsdkUriConverter.replaceProxy((InternalEObject)unresolved));
        EcoreUtil.resolveAll((ResourceSet)kernel.eResource().getResourceSet());
        return null;
    }

    private static void replaceProxy(InternalEObject internal) {
        if (internal.eIsProxy() && internal.eProxyURI().toString().contains(APUKERNEL_S32V234_MODEL)) {
            internal.eSetProxyURI(URI.createURI((String)Apex2PluginVsdkUriConverter.getS32protocolUri(internal.eProxyURI())));
        }
    }

    private static String getS32protocolUri(URI uri) {
        String strUri = uri.toString();
        int ind = strUri.indexOf(APUKERNEL_S32V234_MODEL);
        String postfixPart = strUri.substring(ind + APUKERNEL_S32V234_MODEL.length());
        return ExternalUriProtocol.getProtocol((String)"vsdk_kernels").concat(postfixPart);
    }
}

