/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.variables;

import com.nxp.s32ds.ext.rcp.variables.RcpVariable;
import com.nxp.s32ds.ext.rcp.variables.RcpVariableListener;
import com.nxp.s32ds.ext.rcp.variables.VariableManager;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.runtime.CoreException;

public class RcpVariables {
    public static final RcpVariables INSTANCE = new RcpVariables(VariableManager.INSTANCE);
    private final VariableManager manager;

    protected RcpVariables(VariableManager manager) {
        this.manager = manager;
    }

    protected VariableManager getManager() {
        return this.manager;
    }

    public String relativize(RcpVariable variable, Path nioPath) throws CoreException {
        if (!nioPath.isAbsolute()) {
            return RcpVariables.replaceFileSeparators(RcpVariables.prependVariable(variable, nioPath));
        }
        Path path = this.getPath(variable);
        Path root = path.getRoot();
        if (root == null || !root.equals(nioPath.getRoot())) {
            return RcpVariables.replaceFileSeparators(nioPath.toString());
        }
        return RcpVariables.replaceFileSeparators(RcpVariables.prependVariable(variable, path.relativize(nioPath)));
    }

    public String relativize(RcpVariable variable, String path) throws CoreException {
        return this.relativize(variable, Paths.get(path, new String[0]).normalize());
    }

    public Path getPath(RcpVariable variable) throws CoreException {
        String path = this.manager.performSubstitution(variable.getText());
        return Paths.get(path, new String[0]).normalize();
    }

    public String prependVariable(RcpVariable variable, String path) {
        return RcpVariables.replaceFileSeparators(RcpVariables.prependVariable(variable, Paths.get(path, new String[0])));
    }

    private static String prependVariable(RcpVariable variable, Path nioPath) {
        return String.valueOf(variable.getText()) + File.separatorChar + nioPath.toString();
    }

    private static String replaceFileSeparators(String string) {
        return string.replace('\\', '/');
    }

    public void addListener(RcpVariable variable, RcpVariableListener listener) {
        this.manager.addListener(variable, listener);
    }

    public void removeListener(RcpVariable variable, RcpVariableListener listener) {
        this.manager.removeListener(variable, listener);
    }
}

