/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.databinding.validation.registry;

import com.nxp.s32ds.ext.rcp.databinding.internal.validation.GroupDescriptorImpl;
import com.nxp.s32ds.ext.rcp.databinding.internal.validation.ValidationDescriptorImpl;
import com.nxp.s32ds.ext.rcp.databinding.internal.validation.ValidationGroupDescriptorImpl;
import com.nxp.s32ds.ext.rcp.databinding.validation.registry.GroupRegistry;
import com.nxp.s32ds.ext.rcp.databinding.validation.registry.ValidationRegistry;
import com.nxp.s32ds.ext.rcp.runtime.Extensions;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ValidationRegistryActivator
implements BundleActivator {
    private static final String ID_ATTRIBUTE = "id";
    private static final String BUNDLE_SYMBOLIC_NAME = "com.nxp.s32ds.ext.rcp.databinding";
    private static final String VALIDATION_EXT_POINT = "validations";
    public static final String GROUP_ATTRIBUTE = "group";
    public static final String VALIDATION_ATTRIBUTE = "validator";
    public static final String VALIDATION_GROUP_ATTRIBUTE = "validatorGroup";
    public static final String CLASS_ATTRIBUTE = "class";
    private static BundleContext context;
    private static ValidationRegistryActivator activator;
    private ServiceTracker<ValidationRegistry, ValidationRegistry> validatoinRegistryServiceTracker;
    private ServiceTracker<GroupRegistry, GroupRegistry> groupRegistryServiceTracker;
    private ValidationRegistry validationRegistryService;
    private GroupRegistry groupRegistryService;

    public static ValidationRegistryActivator getDefault() {
        return activator;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        activator = this;
        String validatoinRegistryClassName = ValidationRegistry.class.getName();
        this.validatoinRegistryServiceTracker = new ServiceTracker(context, validatoinRegistryClassName, null);
        this.validatoinRegistryServiceTracker.open();
        this.validationRegistryService = (ValidationRegistry)this.validatoinRegistryServiceTracker.getService();
        this.registerValidators(this.validationRegistryService);
        String groupRegistryClassName = GroupRegistry.class.getName();
        this.groupRegistryServiceTracker = new ServiceTracker(context, groupRegistryClassName, null);
        this.groupRegistryServiceTracker.open();
        this.groupRegistryService = (GroupRegistry)this.groupRegistryServiceTracker.getService();
        this.registerGroups(this.groupRegistryService);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        activator = null;
        context = null;
    }

    private void registerValidators(ValidationRegistry registry) {
        String ns = BUNDLE_SYMBOLIC_NAME;
        String ep = VALIDATION_EXT_POINT;
        List validationElements = Extensions.getConfigrationElements((String)ns, (String)ep, (String)VALIDATION_ATTRIBUTE, (String[])new String[]{ID_ATTRIBUTE});
        for (IConfigurationElement element : validationElements) {
            ValidationDescriptorImpl validationDescriptor = new ValidationDescriptorImpl(element);
            registry.addValidationDescriptor(validationDescriptor);
        }
        List validationGroupElements = Extensions.getConfigrationElements((String)ns, (String)ep, (String)VALIDATION_GROUP_ATTRIBUTE, (String[])new String[0]);
        for (IConfigurationElement element : validationGroupElements) {
            ValidationGroupDescriptorImpl validatorGroupDescr = new ValidationGroupDescriptorImpl(element);
            registry.addValidationGroupDescriptor(validatorGroupDescr);
        }
    }

    private void registerGroups(GroupRegistry registry) {
        String ns = BUNDLE_SYMBOLIC_NAME;
        String ep = VALIDATION_EXT_POINT;
        List groupElements = Extensions.getConfigrationElements((String)ns, (String)ep, (String)GROUP_ATTRIBUTE, (String[])new String[]{ID_ATTRIBUTE});
        for (IConfigurationElement element : groupElements) {
            GroupDescriptorImpl groupDescriptor = new GroupDescriptorImpl(element);
            registry.addGroupDescriptor(groupDescriptor);
        }
    }

    public ValidationRegistry getRegistry() {
        return this.validationRegistryService;
    }
}

