/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.databinding.validation;

import com.nxp.s32ds.ext.rcp.databinding.validation.CIdentifierValidationMessages;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class CIdentifierValidator
implements IValidator {
    private static final String BUNDLE_SYMBOLIC_NAME = "com.nxp.s32ds.ext.rcp.resources";
    private static final Pattern PATTERN = Pattern.compile("^[a-zA-Z_$][a-zA-Z_$0-9]*$");
    private static final int LENGTH_RESTRICTION = 63;
    public static final String ID = "c.identifier";

    public static Pattern getPattern() {
        return PATTERN;
    }

    public IStatus validate(Object value) {
        if (!(value instanceof String)) {
            return CIdentifierValidator.createError(CIdentifierValidationMessages._invalid_name);
        }
        String name = (String)value;
        if (name.length() == 0) {
            return CIdentifierValidator.createError(CIdentifierValidationMessages._empty_name);
        }
        if (name.length() > 63) {
            return CIdentifierValidator.createError(NLS.bind((String)CIdentifierValidationMessages._name_has_length_of_0_characters_exceeds_limit, (Object)name.length()));
        }
        Matcher matcher = PATTERN.matcher(name);
        if (matcher.matches()) {
            return Status.OK_STATUS;
        }
        int i = 0;
        while (i < name.length()) {
            matcher.reset(name.substring(0, i + 1));
            if (!matcher.matches()) {
                if (i > 0) {
                    return CIdentifierValidator.createError(NLS.bind((String)CIdentifierValidationMessages._0_invalid_character_1_should_be_valid_c_identifier, (Object)Character.valueOf(name.charAt(i)), (Object)name));
                }
                return CIdentifierValidator.createError(NLS.bind((String)CIdentifierValidationMessages._0_is_invalid_character_in_1_name_should_starts_from, (Object)Character.valueOf(name.charAt(i)), (Object)name));
            }
            ++i;
        }
        return CIdentifierValidator.createError(CIdentifierValidationMessages._invalid_name);
    }

    private static IStatus createError(String message) {
        return new Status(4, BUNDLE_SYMBOLIC_NAME, message);
    }
}

