/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.databinding.internal.validation;

import com.nxp.s32ds.ext.rcp.databinding.validation.registry.ValidationDescriptor;
import com.nxp.s32ds.ext.rcp.databinding.validation.registry.ValidationGroupDescriptor;
import com.nxp.s32ds.ext.rcp.databinding.validation.registry.ValidationRegistry;
import com.nxp.s32ds.ext.rcp.registry.BaseRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.CoreException;

public class ValidationRegistryImpl
extends BaseRegistry
implements ValidationRegistry {
    private final Map<String, ValidationDescriptor> validatorDescriptors = new HashMap<String, ValidationDescriptor>();
    private final Map<String, Collection<ValidationGroupDescriptor>> validator2validatorDescriptors = new HashMap<String, Collection<ValidationGroupDescriptor>>();
    private final Map<String, Collection<ValidationGroupDescriptor>> group2validatorDescriptors = new HashMap<String, Collection<ValidationGroupDescriptor>>();
    private final Map<ValidationDescriptor, IValidator> descriptor2validator = new HashMap<ValidationDescriptor, IValidator>();

    @Override
    public void addValidationDescriptor(ValidationDescriptor descriptor) {
        try {
            IValidator validator = descriptor.createValidator();
            if (validator != null) {
                this.addEntityDescriptor(descriptor, this.validatorDescriptors, ValidationDescriptor.class);
                this.descriptor2validator.put(descriptor, validator);
            }
        }
        catch (CoreException e) {
            this.log(4, e.getMessage(), e);
        }
    }

    @Override
    public void addValidationGroupDescriptor(ValidationGroupDescriptor descriptor) {
        this.addReferenceDescriptor(descriptor, this.validator2validatorDescriptors, this.group2validatorDescriptors, ValidationGroupDescriptor.class);
    }

    @Override
    public Collection<ValidationGroupDescriptor> getValidatorGroupDescriptorByGroupId(String groupId) {
        return this.getReferenceDescriptorsByTargetId(groupId, this.group2validatorDescriptors, ValidationGroupDescriptor.class);
    }

    @Override
    public IValidator getValidatorByDescriptor(ValidationDescriptor descriptor) {
        return this.descriptor2validator.get(descriptor);
    }

    @Override
    public IValidator addValidatorByDescriptor(ValidationDescriptor descriptor, IValidator validator) {
        return this.descriptor2validator.put(descriptor, validator);
    }

    @Override
    public void removeValidationDescriptor(ValidationDescriptor descriptor) {
        this.removeEntityDescriptor(descriptor, this.validatorDescriptors, ValidationDescriptor.class);
    }

    @Override
    public void removeValidationGroupDescriptor(ValidationGroupDescriptor descriptor) {
        this.removeReferenceDescriptor(descriptor, this.validator2validatorDescriptors, this.group2validatorDescriptors, ValidationGroupDescriptor.class);
    }

    @Override
    public List<ValidationDescriptor> getValidationDescriptors() {
        return new ArrayList<ValidationDescriptor>(this.validatorDescriptors.values());
    }
}

