/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.environment.internal.registry.core;

import com.nxp.s32ds.cle.runtime.environment.internal.registry.core.EnvironmentDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.environment.registry.EnvironmentContributor;
import com.nxp.s32ds.cle.runtime.environment.registry.EnvironmentRegistry;
import com.nxp.s32ds.ext.rcp.runtime.Extensions;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class EnvironmentRegistryCoreActivator
implements BundleActivator {
    private static EnvironmentRegistryCoreActivator activator;
    private static BundleContext context;
    private ServiceTracker<EnvironmentRegistry, EnvironmentRegistry> environmentRegistryServiceTracker;
    private EnvironmentRegistry environmentRegistryService;

    public static EnvironmentRegistryCoreActivator getDefault() {
        return activator;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        activator = this;
        String environmentRegistryClassName = EnvironmentRegistry.class.getName();
        this.environmentRegistryServiceTracker = new ServiceTracker(context, environmentRegistryClassName, null);
        this.environmentRegistryServiceTracker.open();
        this.environmentRegistryService = (EnvironmentRegistry)this.environmentRegistryServiceTracker.getService();
        if (this.environmentRegistryService != null) {
            this.registerEnvironments(this.environmentRegistryService);
        }
    }

    private void registerEnvironments(EnvironmentRegistry registry) {
        String ns = "com.nxp.s32ds.cle.runtime.environment.registry.core";
        String ep = "environments";
        Extensions.getConfigrationElements((String)ns, (String)ep, (String)"env", (String[])new String[0]).stream().map(EnvironmentDescriptorImplementation::new).forEach(arg_0 -> ((EnvironmentRegistry)registry).addEnvironmentDescriptor(arg_0));
        List executables = Extensions.createSimpleExecutableExtensions((String)ns, (String)ep, (String)"contributor", (String)"class", EnvironmentContributor.class);
        executables.forEach(executable -> executable.contribute(registry));
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.environmentRegistryServiceTracker.close();
        this.environmentRegistryServiceTracker = null;
        this.environmentRegistryService = null;
        activator = null;
        context = null;
    }

    public EnvironmentRegistry getEnvironmentRegistry() {
        return this.environmentRegistryService;
    }

    public static IStatus log(IStatus status) {
        Platform.getLog((Bundle)context.getBundle()).log(status);
        return status;
    }

    public static void logInfo(String message) {
        EnvironmentRegistryCoreActivator.log((IStatus)new Status(1, context.getBundle().getSymbolicName(), message));
    }

    public static void logWarning(String message) {
        EnvironmentRegistryCoreActivator.log((IStatus)new Status(2, context.getBundle().getSymbolicName(), message));
    }

    public static void logError(String message) {
        EnvironmentRegistryCoreActivator.log((IStatus)new Status(4, context.getBundle().getSymbolicName(), message));
    }
}

