/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.kernel.loaders;

import com.nxp.s32ds.ext.emf.ecore.EmfResources;
import com.nxp.s32ds.ext.emf.ecore.external.ExternalUriProtocol;
import com.nxp.s32ds.ext.rcp.variables.VariableManager;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPackage;
import com.nxp.s32ds.gte.apukernel.ApuKernelSource;
import com.nxp.s32ds.mdt.vpt.apex2.kernel.internal.loaders.Apex2KernelLoadersActivator;
import com.nxp.s32ds.mdt.vpt.apex2.kernel.loaders.Apex2KernelLoader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public abstract class Apex2ExternalProtocolKernelLoader
implements Apex2KernelLoader {
    @Override
    public List<ApuKernelInfo> load() {
        Collection userKernelsURI = null;
        try {
            userKernelsURI = EmfResources.getAllInternalResources((String)VariableManager.INSTANCE.resolve(this.getProtocolId()), (Pattern)KERNEL_FILE_PATTERN);
        }
        catch (CoreException e1) {
            Apex2KernelLoadersActivator.getInstance().log(e1.getStatus());
            return Collections.emptyList();
        }
        ArrayList<ApuKernelInfo> userKernels = new ArrayList<ApuKernelInfo>();
        userKernelsURI.forEach(kUri -> {
            List<ApuKernelInfo> kernelInfos = this.loadKernelInfos((URI)kUri);
            if (kernelInfos != null) {
                userKernels.addAll(kernelInfos);
            }
        });
        return userKernels;
    }

    protected abstract String getProtocolId();

    protected List<ApuKernelInfo> loadKernelInfos(URI apuKernelUri) {
        ArrayList<ApuKernelInfo> kernelInfos = new ArrayList<ApuKernelInfo>();
        HashMap<String, ApuKernelPackage> loadOptions = new HashMap<String, ApuKernelPackage>();
        loadOptions.put("http://s32ds.nxp.com/apukernel/1.0.0", ApuKernelPackage.eINSTANCE);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource containerResource = resourceSet.getResource(ExternalUriProtocol.deresolve((URI)apuKernelUri, (String)this.getProtocolId()), true);
        try {
            containerResource.load(loadOptions);
        }
        catch (IOException iOException) {
            return null;
        }
        ApuKernelSource kernelSource = (ApuKernelSource)containerResource.getEObject("/");
        if (kernelSource != null) {
            return kernelSource.getKernelInfos();
        }
        return kernelInfos;
    }
}

