/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.kernel.scanner;

import com.nxp.s32ds.ext.emf.ecore.EmfResources;
import com.nxp.s32ds.ext.rcp.runtime.util.FilePaths;
import com.nxp.s32ds.gte.apukernel.ApuKernelPackage;
import com.nxp.s32ds.gte.apukernel.ApuKernelSource;
import com.nxp.s32ds.mdt.vpt.apex2.internal.kernel.scanner.KernelScanner;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class KernelScannerMain {
    private static Logger logger = Logger.getLogger(KernelScannerMain.class);
    private static String kernelsRootPath;
    private static String modelsPath;
    private static String reportFilePath;

    static {
        ApuKernelPackage ePackage = ApuKernelPackage.eINSTANCE;
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        EPackage.Registry.INSTANCE.put((Object)ePackage.getNsURI(), (Object)ePackage);
    }

    public static void main(String[] args) {
        String vsdkPropertiesFilePath;
        Options options = new Options();
        Option kernelsRootPathOption = new Option("k", "kernels", true, "Path to the root directory of VSDK kernels");
        kernelsRootPathOption.setRequired(true);
        options.addOption(kernelsRootPathOption);
        Option modelsPathOption = new Option("p", "path", true, "Path to the directory where kernel models will be generated");
        modelsPathOption.setRequired(true);
        options.addOption(modelsPathOption);
        Option reportFilePathOption = new Option("r", "report", true, "Full path to filled .report file for resolving of defines");
        options.addOption(reportFilePathOption);
        Option vsdkPropertiesFilePathOption = new Option("v", "vsdkProperties", true, "Path to VSDK vsdk.properties file");
        vsdkPropertiesFilePathOption.setRequired(true);
        options.addOption(vsdkPropertiesFilePathOption);
        BasicParser parser = new BasicParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException parseException) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("KernelScanner", options);
            logger.error((Object)"Failed to parse command line properties");
            System.exit(0);
        }
        if (cmd == null) {
            logger.error((Object)"Failed to get command line");
            return;
        }
        kernelsRootPath = cmd.getOptionValue('k');
        boolean pathExists = Files.exists(Paths.get(kernelsRootPath, new String[0]), new LinkOption[0]);
        if (!pathExists) {
            logger.error((Object)"Path to kernels root directory (-k) is not valid");
            System.exit(0);
        }
        if (!(pathExists = Files.exists(Paths.get(modelsPath = cmd.getOptionValue('p'), new String[0]), new LinkOption[0]))) {
            try {
                Files.createDirectory(Paths.get(modelsPath, new String[0]), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                logger.error((Object)"Path to kernels root directory (-k) is not valid");
                System.exit(0);
            }
        }
        if (cmd.hasOption('r') && !(pathExists = Files.exists(Paths.get(reportFilePath = cmd.getOptionValue('r'), new String[0]), new LinkOption[0]))) {
            logger.error((Object)"Path to .report (-k) is not valid, defines won't be resolved");
        }
        if (!Files.exists(Paths.get(vsdkPropertiesFilePath = cmd.getOptionValue('v'), new String[0]), new LinkOption[0])) {
            logger.error((Object)"Path to vsdk properties file (-v) is not valid");
            System.exit(0);
        }
        logger.info((Object)"Scanning...");
        KernelScanner scanner = new KernelScanner(kernelsRootPath, vsdkPropertiesFilePath);
        scanner.scanKernels();
        KernelScannerMain.storeKernelInfos(modelsPath, scanner.getKernelSources());
        if (!scanner.getUnreadableValues().isEmpty()) {
            logger.info((Object)"Store unreadable defines and expressions to .report file...");
            KernelScannerMain.storeUnreadable(modelsPath, scanner.getUnreadableValues());
        }
        if (reportFilePath != null) {
            logger.info((Object)"Resolve define values from .report file");
            KernelScannerMain.processProperties(modelsPath, reportFilePath);
        }
        logger.info((Object)"OK");
    }

    public static void storeKernelInfos(String pathToFolder, Map<Path, ApuKernelSource> mapKernelInfo) {
        if (mapKernelInfo != null) {
            for (Map.Entry<Path, ApuKernelSource> it : mapKernelInfo.entrySet()) {
                Path path = it.getKey();
                String pathString = path.getFileName().toString();
                if (pathString.contains("_acf.")) {
                    pathString = pathString.replace("_acf.", ".");
                }
                String modelName = FilePaths.replaceExtension((String)pathString, (String)"apukernel");
                String parentFolderName = path.getParent().getParent().getFileName().toString();
                String modelPath = String.valueOf(pathToFolder) + File.separator + parentFolderName;
                String platformPath = String.valueOf(modelPath) + File.separator + modelName;
                URI uri = URI.createFileURI((String)platformPath);
                try {
                    EmfResources.save((URI)uri, (EObject)((EObject)it.getValue()));
                }
                catch (Exception exception) {
                    logger.warn((Object)String.format("Cannot save kernel (uri: %s)", uri));
                }
            }
        }
    }

    public static void storeUnreadable(String pathToFolder, Set<String> unreadableList) {
        Path unreadableValuesPathReport = Paths.get(pathToFolder, new String[0]).resolve("unreadable.report");
        Charset charset = StandardCharsets.UTF_8;
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (BufferedWriter writer = Files.newBufferedWriter(unreadableValuesPathReport, charset, new OpenOption[0]);){
                for (String unreadableElement : unreadableList) {
                    writer.write(unreadableElement.concat(" = \n"));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            logger.warn((Object)String.format("Error writing unreadable values file %s", unreadableValuesPathReport));
        }
        logger.error((Object)String.format("There are unresolved defines or constants. File %s has been created. \nPlease, define these values manually in any file, then relaunch tool with path to the file as 3rd parameter to resolve unresolved values", unreadableValuesPathReport));
    }

    public static void processProperties(String folderPath, String pathProperties) {
        logger.debug((Object)"Loading properties...");
        final Map<String, String> properties = KernelScannerMain.loadProperties(pathProperties);
        if (properties == null) {
            return;
        }
        logger.debug((Object)"Processing files...");
        File kernelPath = new File(folderPath);
        if (kernelPath.exists()) {
            SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attr) throws IOException {
                    properties.forEach((k, v) -> {
                        try {
                            Throwable throwable = null;
                            Object var4_6 = null;
                            try (Stream<String> lines = Files.lines(file);){
                                List replaced = lines.map(line -> line.replaceAll(Pattern.quote(k), (String)v)).collect(Collectors.toList());
                                Files.write(file, replaced, new OpenOption[0]);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    });
                    return FileVisitResult.CONTINUE;
                }
            };
            try {
                Files.walkFileTree(kernelPath.toPath(), (FileVisitor<? super Path>)visitor);
                logger.debug((Object)"Processing OK");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isMetaHeader(String filename) {
        return false;
    }

    private static Map<String, String> loadProperties(String path) {
        HashMap<String, String> map = new HashMap<String, String>();
        Path p = Paths.get(path, new String[0]);
        if (!Files.exists(p, new LinkOption[0])) {
            logger.error((Object)String.format("%s is not found. Please check the arguments.", path));
            return null;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Stream<String> stream = Files.lines(p);){
                stream.forEach(line -> {
                    String[] strs = line.split("\\s*=\\s*");
                    if (strs.length == 2) {
                        strs[0] = "\"" + strs[0] + "\"";
                        strs[1] = "\"" + strs[1] + "\"";
                        map.put(strs[0], strs[1]);
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }
}

