/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.internal.kernel.scanner;

import com.nxp.s32ds.ext.rcp.runtime.util.FilePaths;
import com.nxp.s32ds.gte.apukernel.ApuChunkSize;
import com.nxp.s32ds.gte.apukernel.ApuDataScale;
import com.nxp.s32ds.gte.apukernel.ApuDataTiling;
import com.nxp.s32ds.gte.apukernel.ApuDataType;
import com.nxp.s32ds.gte.apukernel.ApuKernelFactory;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortAttributesInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortSpatialDepInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelSource;
import com.nxp.s32ds.gte.apukernel.ApuMemoryPart;
import com.nxp.s32ds.gte.apukernel.ApuPortType;
import com.nxp.s32ds.mdt.vpt.acf.headless.kernel.AcfKernels;
import com.nxp.s32ds.mdt.vpt.apex2.core.standalone.Apex2StandaloneHelper;
import com.nxp.s32ds.mdt.vpt.apex2.core.vsdk.Apex2VsdkHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class KernelScanner {
    private static Logger logger = Logger.getLogger(KernelScanner.class);
    private static final String COMMA = ",";
    private static final String KENEL_END = ");";
    private static final String BRACET_OUT = ")";
    private static final String BRACET_IN = "(";
    private static final String MULTILINE_COMMENT_IN = "/*";
    private static final String MULTILINE_COMMENT_OUT = "*/";
    static final Pattern PATTERN_KERNEL = Pattern.compile("#define\\s+(\\w+_K)\\s+(\\w+)");
    static final Pattern PATTERN_PORT = Pattern.compile("#define\\s+(\\w+)\\s+(\"\\w+\")");
    private final Map<Path, ApuKernelSource> path2kernelSource = new HashMap<Path, ApuKernelSource>();
    private static final Set<String> UNREADABLE_VALUES = new HashSet<String>();
    private String pathKernels;

    public KernelScanner(String pathKernels, String vsdkPropertiesFilePath) {
        this.pathKernels = pathKernels;
        Apex2StandaloneHelper.prepareResolver((String)vsdkPropertiesFilePath, null);
    }

    public boolean scanKernels() {
        File kernelPath = new File(this.pathKernels);
        if (kernelPath.exists()) {
            SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attr) throws IOException {
                    String[] availableKernelFolders = Apex2VsdkHelper.getInstance().getAvailableKernelFolders();
                    if (!file.toString().contains(availableKernelFolders[0]) && !file.toString().contains(availableKernelFolders[1])) {
                        return FileVisitResult.CONTINUE;
                    }
                    String fileName = file.getFileName().toString().toLowerCase();
                    String path = file.toAbsolutePath().toString();
                    Apex2VsdkHelper vsdkHelper = Apex2VsdkHelper.getInstance();
                    if ((fileName.endsWith(vsdkHelper.getPatternC()) || fileName.endsWith(vsdkHelper.getPatternCpp())) && !fileName.contains(vsdkHelper.getPatternImpl())) {
                        HashMap kernelNames = new HashMap();
                        HashMap portNames = new HashMap();
                        try {
                            KernelScanner.processMetaHeader(file.toAbsolutePath(), kernelNames, portNames);
                            Map processed = KernelScanner.processMetaImpl(file, kernelNames, portNames);
                            KernelScanner.this.path2kernelSource.putAll(processed);
                        }
                        catch (Throwable t) {
                            String message = String.format("Error scaning file %s", path);
                            logger.warn((Object)message, t);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            };
            try {
                Files.walkFileTree(kernelPath.toPath(), (FileVisitor<? super Path>)visitor);
            }
            catch (IOException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    private static Map<Path, ApuKernelSource> processMetaImpl(Path metaImplPath, Map<String, String> kernelIds, Map<String, String> portIds) throws IOException {
        HashMap<Path, ApuKernelSource> paths2Sources = new HashMap<Path, ApuKernelSource>();
        String line = "";
        File metaImplFile = metaImplPath.toFile();
        String metaHeaderName = FilePaths.replaceExtension((String)metaImplFile.getName(), (String)"h");
        Path metaHeaderPath = metaImplPath.resolveSibling(metaHeaderName);
        String metaHeaderStrPath = metaHeaderPath.toAbsolutePath().toString();
        ApuKernelSource source = ApuKernelFactory.eINSTANCE.createApuKernelSource();
        source.setOrigin("s32v234");
        source.setCategory(KernelScanner.extractCategory(metaImplFile));
        source.setInclude(metaHeaderPath.getFileName().toString());
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(metaImplFile));){
                AcfKernels.ScanState state = AcfKernels.ScanState.SCAN_KERNEL;
                ApuKernelInfo kernelInfo = null;
                ApuKernelPortInfo portInfo = null;
                block17: while ((line = br.readLine()) != null) {
                    if (line.contains(KENEL_END)) {
                        state = AcfKernels.ScanState.SCAN_KERNEL;
                    }
                    switch (state) {
                        case SCAN_KERNEL: {
                            String kernelName;
                            if (!line.contains("KERNEL_INFO") || (kernelName = KernelScanner.unsafeExtractFromBrackets(line).trim()).isEmpty()) continue block17;
                            kernelInfo = ApuKernelFactory.eINSTANCE.createApuKernelInfo();
                            String kernelId = kernelIds.get(kernelName);
                            if (kernelId == null) {
                                logger.debug((Object)String.format("Identifier not found for kernel (name): %s ", kernelName));
                            } else {
                                kernelInfo.setName(kernelId);
                            }
                            kernelInfo.setAlias(kernelName);
                            source.getKernelInfos().add((Object)kernelInfo);
                            state = AcfKernels.ScanState.SCAN_PORT;
                            break;
                        }
                        case SCAN_PORT: {
                            if (!line.contains("__port")) break;
                            portInfo = ApuKernelFactory.eINSTANCE.createApuKernelPortInfo();
                            kernelInfo.getPortInfos().add((Object)portInfo);
                            state = AcfKernels.ScanState.SCAN_ID;
                            break;
                        }
                        case SCAN_ID: {
                            if (!line.contains("__identifier")) break;
                            String portName = KernelScanner.unsafeExtractFromBrackets(line);
                            if (portName.startsWith("\"") && portName.endsWith("\"")) {
                                if (portInfo != null) {
                                    portInfo.setName(portName);
                                }
                            } else {
                                String portId = portIds.get(portName);
                                if (portId == null) {
                                    logger.debug((Object)String.format("Identifier not found for port (name): %s ", portName));
                                } else {
                                    portInfo.setName(portId);
                                }
                            }
                            portInfo.setAlias(portName);
                            state = AcfKernels.ScanState.SCAN_ATTR;
                            break;
                        }
                        case SCAN_ATTR: {
                            String attributes;
                            if (!line.contains("__attributes") || (attributes = KernelScanner.unsafeExtractFromBrackets(line)).isEmpty()) continue block17;
                            KernelScanner.setAttributesForPort(portInfo, attributes);
                            state = AcfKernels.ScanState.SCAN_SD;
                            break;
                        }
                        case SCAN_SD: {
                            if (!line.contains("__spatial_dep")) break;
                            String value = KernelScanner.unsafeExtractFromBrackets(line);
                            String[] split = value.split(COMMA);
                            KernelScanner.collectUndearable(split, metaHeaderStrPath);
                            if (split.length == 4) {
                                ApuKernelPortSpatialDepInfo portSpatialDep = portInfo.getPortSpatialDepInfo();
                                portSpatialDep.setSpatialDepLeft(split[0].trim());
                                portSpatialDep.setSpatialDepRight(split[1].trim());
                                portSpatialDep.setSpatialDepTop(split[2].trim());
                                portSpatialDep.setSpatialDepBottom(split[3].trim());
                            }
                            state = AcfKernels.ScanState.SCAN_DT;
                            break;
                        }
                        case SCAN_DT: {
                            if (!line.contains("__e0_data_type")) break;
                            String dataType = KernelScanner.unsafeExtractFromBrackets(line);
                            ApuDataType portDataType = ApuDataType.get((String)dataType);
                            if (portDataType != null) {
                                portInfo.getPortElementsInfo().setE0DataType(portDataType);
                            }
                            state = AcfKernels.ScanState.SCAN_E0;
                            break;
                        }
                        case SCAN_E0: {
                            if (!line.contains("__e0_size")) break;
                            String value = KernelScanner.unsafeExtractFromBrackets(line);
                            String[] split = value.split(COMMA);
                            KernelScanner.collectUndearable(split, metaHeaderStrPath);
                            if (split.length == 2) {
                                portInfo.getPortElementsInfo().setE0SizeX(split[0].trim());
                                portInfo.getPortElementsInfo().setE0SizeY(split[1].trim());
                            }
                            state = AcfKernels.ScanState.SCAN_EK;
                            break;
                        }
                        case SCAN_EK: {
                            if (!line.contains("__ek_size")) break;
                            String value = KernelScanner.unsafeExtractFromBrackets(line);
                            String[] split = value.split(COMMA);
                            KernelScanner.collectUndearable(split, metaHeaderStrPath);
                            if (split.length == 2) {
                                portInfo.getPortElementsInfo().setEKSizeX(split[0].trim());
                                portInfo.getPortElementsInfo().setEKSizeY(split[1].trim());
                            }
                            state = AcfKernels.ScanState.SCAN_PORT;
                            break;
                        }
                    }
                }
                if (source.getKernelInfos().size() > 0) {
                    paths2Sources.put(metaImplPath, source);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return paths2Sources;
    }

    private static void collectUndearable(String[] values, String path) {
        int i = 0;
        while (i < values.length) {
            block3: {
                String trimmedValue = values[i].trim();
                try {
                    Integer.parseInt(trimmedValue);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!UNREADABLE_VALUES.add(trimmedValue)) break block3;
                    logger.info((Object)(String.valueOf(trimmedValue) + " (" + path + ") is not a number"));
                }
            }
            ++i;
        }
    }

    private static void processMetaHeader(Path filePath, Map<String, String> kernelIds, Map<String, String> portIds) throws IOException {
        String extractedName = FilePaths.replaceExtension((String)filePath.getFileName().toString(), (String)"h");
        Path hFile = Paths.get(filePath.toFile().getParentFile().toString(), extractedName);
        if (Files.exists(hFile, new LinkOption[0])) {
            logger.debug((Object)String.format("Kernel Meta Header: %s", hFile));
            try {
                Throwable throwable = null;
                Object var7_8 = null;
                try (BufferedReader br = new BufferedReader(new FileReader(hFile.toFile()));){
                    try {
                        String line;
                        while ((line = br.readLine()) != null) {
                            Matcher kernelMatcher = PATTERN_KERNEL.matcher(line);
                            while (kernelMatcher.find()) {
                                String name = kernelMatcher.group(1).trim();
                                String identifier = kernelMatcher.group(2).trim();
                                kernelIds.put(name, identifier);
                            }
                            Matcher portMatcher = PATTERN_PORT.matcher(line);
                            while (portMatcher.find()) {
                                String name = portMatcher.group(1).trim();
                                String identifier = portMatcher.group(2).trim();
                                identifier = identifier.substring(1, identifier.length() - 1);
                                portIds.put(name, identifier);
                            }
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw e;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        logger.debug((Object)"\n\n----next----");
    }

    private static String extractCategory(File file) {
        File categoryDir;
        File srcDir = file.getParentFile();
        if (srcDir != null && (categoryDir = srcDir.getParentFile()) != null) {
            return categoryDir.getName();
        }
        return "";
    }

    private static String unsafeExtractFromBrackets(String line) {
        String newLine = line;
        if (line.indexOf(BRACET_IN) <= -1 || line.indexOf(BRACET_OUT) <= -1) {
            return "";
        }
        newLine = line.substring(line.indexOf(BRACET_IN) + 1, line.indexOf(BRACET_OUT));
        int commIn = newLine.indexOf(MULTILINE_COMMENT_IN);
        int commOut = newLine.indexOf(MULTILINE_COMMENT_OUT);
        while (commIn > -1 && commOut > -1) {
            newLine = newLine.replace(newLine.substring(commIn, commOut + MULTILINE_COMMENT_OUT.length()), "");
            commIn = newLine.indexOf(MULTILINE_COMMENT_IN);
            commOut = newLine.indexOf(MULTILINE_COMMENT_OUT);
        }
        return newLine;
    }

    private static void setAttributesForPort(ApuKernelPortInfo portInfo, String attributes) {
        ApuKernelPortAttributesInfo portAttrbutes = portInfo.getPortAttrbutesInfo();
        portAttrbutes.setDataTiling(ApuDataTiling.ATTR_NONSTATIC);
        portAttrbutes.setDataScale(ApuDataScale.ATTR_NONFIXED);
        portAttrbutes.setChunkSize(ApuChunkSize.ATTR_REG);
        if (attributes.contains("IN")) {
            portAttrbutes.setPortType(ApuPortType.ATTR_IN);
        } else if (attributes.contains("OUT")) {
            portAttrbutes.setPortType(ApuPortType.ATTR_OUT);
        }
        if (attributes.contains("VEC")) {
            portAttrbutes.setMemoryPart(ApuMemoryPart.ATTR_CMEM);
        } else if (attributes.contains("SCL")) {
            portAttrbutes.setMemoryPart(ApuMemoryPart.ATTR_DMEM);
        }
        if (attributes.contains("STATIC")) {
            portAttrbutes.setDataTiling(ApuDataTiling.ATTR_STATIC);
        }
        if (attributes.contains("FIXED")) {
            portAttrbutes.setDataScale(ApuDataScale.ATTR_FIXED);
        }
        if (attributes.contains("FIFO")) {
            portAttrbutes.setChunkSize(ApuChunkSize.ATTR_FIFO);
        }
    }

    public Map<Path, ApuKernelSource> getKernelSources() {
        return this.path2kernelSource;
    }

    public Set<String> getUnreadableValues() {
        return UNREADABLE_VALUES;
    }
}

