/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.arm.core;

import com.freescale.s32ds.cross.core.model.DefaultWizardValueProvider;
import com.freescale.s32ds.cross.core.model.IWizardValueProvider;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.freescale.s32ds.cross.sdk.SDKContextUtil;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ArmWizardValueProvider
extends DefaultWizardValueProvider
implements IWizardValueProvider {
    private static final String TEMPLATE_VARIABLE_PEX = "pex";
    private static final String TEMPLATE_VARIABLE_UCT = "uct";
    private static final String TEMPLATE_VARIABLE_PROJECT_BASE_TEMPLATE = "project.base.template";
    private static final String TAG_VALUE_UCT = "uct";

    public Map<String, String> createValueMap(ProjectContext context, String location) {
        Map mapSdkByTag;
        Map res = super.createValueMap(context, location);
        if (!(context instanceof CProjectContext)) {
            return res;
        }
        CProjectContext projectContext = (CProjectContext)context;
        String name = projectContext.getProjectName();
        ProcessorContext processorContext = projectContext.getProcessorContext();
        List coreNatures = processorContext.getCoreNatures();
        int si = name.lastIndexOf(95);
        if (processorContext.isMultiple() && si > 0) {
            name = name.substring(0, si);
        }
        res.put("GROUP_NAME", coreNatures.size() < 2 ? "" : projectContext.getProjectBaseName());
        res.put("DEVICE_NAME", processorContext.getProcessor().getId());
        res.put("projectNameSafe", Pattern.quote(projectContext.getProjectName()));
        res.put("GROUP_SAFE", coreNatures.size() < 2 ? "" : Pattern.quote(projectContext.getProjectBaseName()));
        if (projectContext.isExecutable()) {
            res.put("FLASH_START", Long.toHexString(projectContext.getLongValue("flashStart")));
            res.put("RAM_START", Long.toHexString(projectContext.getLongValue("ramStart")));
            res.put("FLASH_LENGTH", Long.toString(projectContext.getLongValue("flashSize") / 1024L));
            res.put("RAM_LENGTH", Long.toString(projectContext.getLongValue("ramSize") / 1024L));
        }
        int cnt = 0;
        int num_cores = 0;
        for (CProjectContext c : processorContext.getProjectContexts()) {
            String p = "TURN_ON_CPU" + cnt;
            String n = "PROJECT_NAME_" + cnt;
            String indx = "PROJECT_INDEX_" + cnt;
            res.put(p, Boolean.toString(c.isActive()));
            if (c.isExecutable()) {
                String f = "FLASH_START_" + (cnt + 1);
                String r = "RAM_START_" + (cnt + 1);
                String f_s = "FLASH_LENGTH_" + (cnt + 1);
                String r_s = "RAM_LENGTH_" + (cnt + 1);
                res.put(f, Long.toHexString(c.getLongValue("flashStart")));
                res.put(r, Long.toHexString(c.getLongValue("ramStart")));
                res.put(f_s, Long.toHexString(c.getLongValue("flashSize")));
                res.put(r_s, Long.toHexString(c.getLongValue("ramSize")));
            }
            if (c.isActive()) {
                res.put(indx, Integer.toString(num_cores));
                ++num_cores;
            } else {
                res.put(indx, Integer.toString(0));
            }
            String name_gr = coreNatures.size() < 2 ? "" : projectContext.getProjectBaseName();
            res.put(n, String.valueOf(name_gr) + "_" + c.getSuffix());
            ++cnt;
        }
        res.put("NUMBER_OF_SLAVE_CORES", Integer.toString(num_cores - 1));
        res.put(TEMPLATE_VARIABLE_PEX, Boolean.toString(SDKContextUtil.isPex((CProjectContext)projectContext)));
        res.put("uct", Boolean.FALSE.toString());
        res.put(TEMPLATE_VARIABLE_PROJECT_BASE_TEMPLATE, Boolean.FALSE.toString());
        Map mapSdkByTargetProjectTemplate = SDKContextUtil.getSdksTargetProjectTemplateIds((CProjectContext)projectContext);
        if (mapSdkByTargetProjectTemplate != null && mapSdkByTargetProjectTemplate.size() == 1 && mapSdkByTargetProjectTemplate.containsKey(TEMPLATE_VARIABLE_PROJECT_BASE_TEMPLATE)) {
            res.put(TEMPLATE_VARIABLE_PROJECT_BASE_TEMPLATE, Boolean.TRUE.toString());
        }
        if ((mapSdkByTag = SDKContextUtil.getSdksGroupByTags((CProjectContext)projectContext)) != null && mapSdkByTag.containsKey("uct")) {
            res.put("uct", Boolean.TRUE.toString());
        }
        return res;
    }

    private String getLaunchName(String name, int coresNum) {
        if (coresNum < 2) {
            return "";
        }
        int slPos = 0;
        String nm = name;
        slPos = name.lastIndexOf(95);
        if (slPos > 0) {
            nm = name.substring(0, slPos);
        }
        return nm;
    }
}

