/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.launch.core;

import com.nxp.s32ds.cle.ide.launch.core.internal.LaunchConfigurationActivator;
import com.nxp.s32ds.cle.ide.launch.core.internal.LaunchConfigurationErrorMessages;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.CoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.ext.ide.launch.core.LaunchConfigurationSupportConstants;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class LaunchConfigurationUtil {
    public static final String DOT_ELF = ".elf";
    public static final String CONTAINER_PATH = "Project_Settings/Debugger";
    public static final String DOT_LAUNCH = ".launch";

    public static IProject extractProject(Map<String, Object> attributes) throws CoreException {
        Object projectValue = attributes.get(LaunchConfigurationSupportConstants.PROJECT_KEY);
        if (!(projectValue instanceof IProject)) {
            String message = LaunchConfigurationErrorMessages.LaunchAttribute_project_undefined;
            IStatus error = LaunchConfigurationActivator.createErrorStatus(message);
            throw new CoreException(error);
        }
        IProject hostProject = (IProject)projectValue;
        return hostProject;
    }

    public static String extractProjectExecutable(Map<String, Object> attributes) throws CoreException {
        Object executableValue = attributes.get("projectExecutable");
        if (!(executableValue instanceof String)) {
            String message = LaunchConfigurationErrorMessages.LaunchAttribute_project_undefined;
            IStatus error = LaunchConfigurationActivator.createErrorStatus(message);
            throw new CoreException(error);
        }
        String projectExecutable = (String)executableValue;
        return projectExecutable;
    }

    public static String extractComponent(Map<String, Object> attributes) throws CoreException {
        Object componentIdValue = attributes.get("com.nxp.s32ds.cle.runtime.component.registry.component.id");
        if (!(componentIdValue instanceof String)) {
            String message = LaunchConfigurationErrorMessages.LaunchAttribute_program_name_undefined;
            IStatus error = LaunchConfigurationActivator.createErrorStatus(message);
            throw new CoreException(error);
        }
        String component = (String)componentIdValue;
        return component;
    }

    public static String extractHardwareFamilyId(Map<String, Object> attributes) throws CoreException {
        Object familyId = attributes.get("com.nxp.s32ds.cle.runtime.hardware.registry.family.id");
        if (familyId instanceof String) {
            return (String)familyId;
        }
        String message = LaunchConfigurationErrorMessages.LaunchAttribute_family_id_undefined;
        IStatus error = LaunchConfigurationActivator.createErrorStatus(message);
        throw new CoreException(error);
    }

    public static String extractHardwareDeviceId(Map<String, Object> attributes) throws CoreException {
        Object familyId = attributes.get("com.nxp.s32ds.cle.runtime.hardware.registry.device.id");
        if (familyId instanceof String) {
            return (String)familyId;
        }
        String message = LaunchConfigurationErrorMessages.LaunchAttribute_family_id_undefined;
        IStatus error = LaunchConfigurationActivator.createErrorStatus(message);
        throw new CoreException(error);
    }

    public static String extractHardwareCoreId(Map<String, Object> attributes) throws CoreException {
        Object coreId = attributes.get("com.nxp.s32ds.cle.runtime.hardware.registry.core.id");
        if (coreId instanceof String) {
            return (String)coreId;
        }
        String message = LaunchConfigurationErrorMessages.LaunchAttribute_family_id_undefined;
        IStatus error = LaunchConfigurationActivator.createErrorStatus(message);
        throw new CoreException(error);
    }

    public static IStatus getUndefinedLaunchConfigurationTypeErrorStatus() {
        String message = LaunchConfigurationErrorMessages.LaunchConfigurationType_undefined;
        return LaunchConfigurationActivator.createErrorStatus(message);
    }

    public static IStatus getLaunchConfigurationExistsErrorStatus() {
        String message = LaunchConfigurationErrorMessages.LaunchConfigurationType_undefined;
        return LaunchConfigurationActivator.createErrorStatus(message);
    }

    public static String getGDBClientValue(String deviceCoreId, String debuggerId) {
        String gdbClientVariable;
        DeviceCoreDescriptor deviceCoreDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId);
        if (deviceCoreDescriptor != null && (gdbClientVariable = CoreDebuggerDescriptors.getClientPath((String)deviceCoreDescriptor.getCoreId(), (String)debuggerId)) != null && !gdbClientVariable.isEmpty()) {
            return gdbClientVariable;
        }
        return "gdb";
    }
}

